/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.keyspaces.model.CdcPropagateTags;
import software.amazon.awssdk.services.keyspaces.model.CdcStatus;
import software.amazon.awssdk.services.keyspaces.model.Tag;
import software.amazon.awssdk.services.keyspaces.model.TagListCopier;
import software.amazon.awssdk.services.keyspaces.model.ViewType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CdcSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CdcSpecification> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CdcSpecification.getter(CdcSpecification::statusAsString)).setter(CdcSpecification.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> VIEW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("viewType").getter(CdcSpecification.getter(CdcSpecification::viewTypeAsString)).setter(CdcSpecification.setter(Builder::viewType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("viewType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CdcSpecification.getter(CdcSpecification::tags)).setter(CdcSpecification.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROPAGATE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propagateTags").getter(CdcSpecification.getter(CdcSpecification::propagateTagsAsString)).setter(CdcSpecification.setter(Builder::propagateTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, VIEW_TYPE_FIELD, TAGS_FIELD, PROPAGATE_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CdcSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String viewType;
    private final List<Tag> tags;
    private final String propagateTags;

    private CdcSpecification(BuilderImpl builder) {
        this.status = builder.status;
        this.viewType = builder.viewType;
        this.tags = builder.tags;
        this.propagateTags = builder.propagateTags;
    }

    public final CdcStatus status() {
        return CdcStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ViewType viewType() {
        return ViewType.fromValue(this.viewType);
    }

    public final String viewTypeAsString() {
        return this.viewType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final CdcPropagateTags propagateTags() {
        return CdcPropagateTags.fromValue(this.propagateTags);
    }

    public final String propagateTagsAsString() {
        return this.propagateTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.propagateTagsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CdcSpecification)) {
            return false;
        }
        CdcSpecification other = (CdcSpecification)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.viewTypeAsString(), other.viewTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.propagateTagsAsString(), other.propagateTagsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CdcSpecification").add("Status", (Object)this.statusAsString()).add("ViewType", (Object)this.viewTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("PropagateTags", (Object)this.propagateTagsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "viewType": {
                return Optional.ofNullable(clazz.cast(this.viewTypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "propagateTags": {
                return Optional.ofNullable(clazz.cast(this.propagateTagsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("viewType", VIEW_TYPE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("propagateTags", PROPAGATE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CdcSpecification, T> g) {
        return obj -> g.apply((CdcSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String viewType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String propagateTags;

        private BuilderImpl() {
        }

        private BuilderImpl(CdcSpecification model) {
            this.status(model.status);
            this.viewType(model.viewType);
            this.tags(model.tags);
            this.propagateTags(model.propagateTags);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CdcStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getViewType() {
            return this.viewType;
        }

        public final void setViewType(String viewType) {
            this.viewType = viewType;
        }

        @Override
        public final Builder viewType(String viewType) {
            this.viewType = viewType;
            return this;
        }

        @Override
        public final Builder viewType(ViewType viewType) {
            this.viewType(viewType == null ? null : viewType.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPropagateTags() {
            return this.propagateTags;
        }

        public final void setPropagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        public final Builder propagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        @Override
        public final Builder propagateTags(CdcPropagateTags propagateTags) {
            this.propagateTags(propagateTags == null ? null : propagateTags.toString());
            return this;
        }

        public CdcSpecification build() {
            return new CdcSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CdcSpecification> {
        public Builder status(String var1);

        public Builder status(CdcStatus var1);

        public Builder viewType(String var1);

        public Builder viewType(ViewType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder propagateTags(String var1);

        public Builder propagateTags(CdcPropagateTags var1);
    }
}

