/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.keyspaces.model.CapacitySpecificationSummary;
import software.amazon.awssdk.services.keyspaces.model.TableStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicaSpecificationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicaSpecificationSummary> {
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(ReplicaSpecificationSummary.getter(ReplicaSpecificationSummary::region)).setter(ReplicaSpecificationSummary.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ReplicaSpecificationSummary.getter(ReplicaSpecificationSummary::statusAsString)).setter(ReplicaSpecificationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<CapacitySpecificationSummary> CAPACITY_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("capacitySpecification").getter(ReplicaSpecificationSummary.getter(ReplicaSpecificationSummary::capacitySpecification)).setter(ReplicaSpecificationSummary.setter(Builder::capacitySpecification)).constructor(CapacitySpecificationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacitySpecification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, STATUS_FIELD, CAPACITY_SPECIFICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplicaSpecificationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String region;
    private final String status;
    private final CapacitySpecificationSummary capacitySpecification;

    private ReplicaSpecificationSummary(BuilderImpl builder) {
        this.region = builder.region;
        this.status = builder.status;
        this.capacitySpecification = builder.capacitySpecification;
    }

    public final String region() {
        return this.region;
    }

    public final TableStatus status() {
        return TableStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final CapacitySpecificationSummary capacitySpecification() {
        return this.capacitySpecification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacitySpecification());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaSpecificationSummary)) {
            return false;
        }
        ReplicaSpecificationSummary other = (ReplicaSpecificationSummary)obj;
        return Objects.equals(this.region(), other.region()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.capacitySpecification(), other.capacitySpecification());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicaSpecificationSummary").add("Region", (Object)this.region()).add("Status", (Object)this.statusAsString()).add("CapacitySpecification", (Object)this.capacitySpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "capacitySpecification": {
                return Optional.ofNullable(clazz.cast(this.capacitySpecification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("region", REGION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("capacitySpecification", CAPACITY_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicaSpecificationSummary, T> g) {
        return obj -> g.apply((ReplicaSpecificationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String region;
        private String status;
        private CapacitySpecificationSummary capacitySpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaSpecificationSummary model) {
            this.region(model.region);
            this.status(model.status);
            this.capacitySpecification(model.capacitySpecification);
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TableStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final CapacitySpecificationSummary.Builder getCapacitySpecification() {
            return this.capacitySpecification != null ? this.capacitySpecification.toBuilder() : null;
        }

        public final void setCapacitySpecification(CapacitySpecificationSummary.BuilderImpl capacitySpecification) {
            this.capacitySpecification = capacitySpecification != null ? capacitySpecification.build() : null;
        }

        @Override
        public final Builder capacitySpecification(CapacitySpecificationSummary capacitySpecification) {
            this.capacitySpecification = capacitySpecification;
            return this;
        }

        public ReplicaSpecificationSummary build() {
            return new ReplicaSpecificationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicaSpecificationSummary> {
        public Builder region(String var1);

        public Builder status(String var1);

        public Builder status(TableStatus var1);

        public Builder capacitySpecification(CapacitySpecificationSummary var1);

        default public Builder capacitySpecification(Consumer<CapacitySpecificationSummary.Builder> capacitySpecification) {
            return this.capacitySpecification((CapacitySpecificationSummary)((CapacitySpecificationSummary.Builder)CapacitySpecificationSummary.builder().applyMutation(capacitySpecification)).build());
        }
    }
}

