/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.keyspaces.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusteringKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusteringKey> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ClusteringKey.getter(ClusteringKey::name)).setter(ClusteringKey.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ORDER_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("orderBy").getter(ClusteringKey.getter(ClusteringKey::orderByAsString)).setter(ClusteringKey.setter(Builder::orderBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ORDER_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("orderBy", ORDER_BY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String orderBy;

    private ClusteringKey(BuilderImpl builder) {
        this.name = builder.name;
        this.orderBy = builder.orderBy;
    }

    public final String name() {
        return this.name;
    }

    public final SortOrder orderBy() {
        return SortOrder.fromValue(this.orderBy);
    }

    public final String orderByAsString() {
        return this.orderBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderByAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusteringKey)) {
            return false;
        }
        ClusteringKey other = (ClusteringKey)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.orderByAsString(), other.orderByAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ClusteringKey").add("Name", (Object)this.name()).add("OrderBy", (Object)this.orderByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "orderBy": {
                return Optional.ofNullable(clazz.cast(this.orderByAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClusteringKey, T> g) {
        return obj -> g.apply((ClusteringKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String orderBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusteringKey model) {
            this.name(model.name);
            this.orderBy(model.orderBy);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOrderBy() {
            return this.orderBy;
        }

        public final void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        @Override
        public final Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public final Builder orderBy(SortOrder orderBy) {
            this.orderBy(orderBy == null ? null : orderBy.toString());
            return this;
        }

        public ClusteringKey build() {
            return new ClusteringKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusteringKey> {
        public Builder name(String var1);

        public Builder orderBy(String var1);

        public Builder orderBy(SortOrder var1);
    }
}

