/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.keyspaces.model.AutoScalingSpecification;
import software.amazon.awssdk.services.keyspaces.model.KeyspacesResponse;
import software.amazon.awssdk.services.keyspaces.model.ReplicaAutoScalingSpecification;
import software.amazon.awssdk.services.keyspaces.model.ReplicaAutoScalingSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTableAutoScalingSettingsResponse
extends KeyspacesResponse
implements ToCopyableBuilder<Builder, GetTableAutoScalingSettingsResponse> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyspaceName").getter(GetTableAutoScalingSettingsResponse.getter(GetTableAutoScalingSettingsResponse::keyspaceName)).setter(GetTableAutoScalingSettingsResponse.setter(Builder::keyspaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableName").getter(GetTableAutoScalingSettingsResponse.getter(GetTableAutoScalingSettingsResponse::tableName)).setter(GetTableAutoScalingSettingsResponse.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(GetTableAutoScalingSettingsResponse.getter(GetTableAutoScalingSettingsResponse::resourceArn)).setter(GetTableAutoScalingSettingsResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<AutoScalingSpecification> AUTO_SCALING_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoScalingSpecification").getter(GetTableAutoScalingSettingsResponse.getter(GetTableAutoScalingSettingsResponse::autoScalingSpecification)).setter(GetTableAutoScalingSettingsResponse.setter(Builder::autoScalingSpecification)).constructor(AutoScalingSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingSpecification").build()}).build();
    private static final SdkField<List<ReplicaAutoScalingSpecification>> REPLICA_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("replicaSpecifications").getter(GetTableAutoScalingSettingsResponse.getter(GetTableAutoScalingSettingsResponse::replicaSpecifications)).setter(GetTableAutoScalingSettingsResponse.setter(Builder::replicaSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaSpecifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicaAutoScalingSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD, TABLE_NAME_FIELD, RESOURCE_ARN_FIELD, AUTO_SCALING_SPECIFICATION_FIELD, REPLICA_SPECIFICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("keyspaceName", KEYSPACE_NAME_FIELD);
            this.put("tableName", TABLE_NAME_FIELD);
            this.put("resourceArn", RESOURCE_ARN_FIELD);
            this.put("autoScalingSpecification", AUTO_SCALING_SPECIFICATION_FIELD);
            this.put("replicaSpecifications", REPLICA_SPECIFICATIONS_FIELD);
        }
    });
    private final String keyspaceName;
    private final String tableName;
    private final String resourceArn;
    private final AutoScalingSpecification autoScalingSpecification;
    private final List<ReplicaAutoScalingSpecification> replicaSpecifications;

    private GetTableAutoScalingSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.tableName = builder.tableName;
        this.resourceArn = builder.resourceArn;
        this.autoScalingSpecification = builder.autoScalingSpecification;
        this.replicaSpecifications = builder.replicaSpecifications;
    }

    public final String keyspaceName() {
        return this.keyspaceName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final AutoScalingSpecification autoScalingSpecification() {
        return this.autoScalingSpecification;
    }

    public final boolean hasReplicaSpecifications() {
        return this.replicaSpecifications != null && !(this.replicaSpecifications instanceof SdkAutoConstructList);
    }

    public final List<ReplicaAutoScalingSpecification> replicaSpecifications() {
        return this.replicaSpecifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicaSpecifications() ? this.replicaSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableAutoScalingSettingsResponse)) {
            return false;
        }
        GetTableAutoScalingSettingsResponse other = (GetTableAutoScalingSettingsResponse)((Object)obj);
        return Objects.equals(this.keyspaceName(), other.keyspaceName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.autoScalingSpecification(), other.autoScalingSpecification()) && this.hasReplicaSpecifications() == other.hasReplicaSpecifications() && Objects.equals(this.replicaSpecifications(), other.replicaSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"GetTableAutoScalingSettingsResponse").add("KeyspaceName", (Object)this.keyspaceName()).add("TableName", (Object)this.tableName()).add("ResourceArn", (Object)this.resourceArn()).add("AutoScalingSpecification", (Object)this.autoScalingSpecification()).add("ReplicaSpecifications", this.hasReplicaSpecifications() ? this.replicaSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyspaceName": {
                return Optional.ofNullable(clazz.cast(this.keyspaceName()));
            }
            case "tableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "autoScalingSpecification": {
                return Optional.ofNullable(clazz.cast(this.autoScalingSpecification()));
            }
            case "replicaSpecifications": {
                return Optional.ofNullable(clazz.cast(this.replicaSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTableAutoScalingSettingsResponse, T> g) {
        return obj -> g.apply((GetTableAutoScalingSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KeyspacesResponse.BuilderImpl
    implements Builder {
        private String keyspaceName;
        private String tableName;
        private String resourceArn;
        private AutoScalingSpecification autoScalingSpecification;
        private List<ReplicaAutoScalingSpecification> replicaSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableAutoScalingSettingsResponse model) {
            super(model);
            this.keyspaceName(model.keyspaceName);
            this.tableName(model.tableName);
            this.resourceArn(model.resourceArn);
            this.autoScalingSpecification(model.autoScalingSpecification);
            this.replicaSpecifications(model.replicaSpecifications);
        }

        public final String getKeyspaceName() {
            return this.keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final AutoScalingSpecification.Builder getAutoScalingSpecification() {
            return this.autoScalingSpecification != null ? this.autoScalingSpecification.toBuilder() : null;
        }

        public final void setAutoScalingSpecification(AutoScalingSpecification.BuilderImpl autoScalingSpecification) {
            this.autoScalingSpecification = autoScalingSpecification != null ? autoScalingSpecification.build() : null;
        }

        @Override
        public final Builder autoScalingSpecification(AutoScalingSpecification autoScalingSpecification) {
            this.autoScalingSpecification = autoScalingSpecification;
            return this;
        }

        public final List<ReplicaAutoScalingSpecification.Builder> getReplicaSpecifications() {
            List<ReplicaAutoScalingSpecification.Builder> result = ReplicaAutoScalingSpecificationListCopier.copyToBuilder(this.replicaSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicaSpecifications(Collection<ReplicaAutoScalingSpecification.BuilderImpl> replicaSpecifications) {
            this.replicaSpecifications = ReplicaAutoScalingSpecificationListCopier.copyFromBuilder(replicaSpecifications);
        }

        @Override
        public final Builder replicaSpecifications(Collection<ReplicaAutoScalingSpecification> replicaSpecifications) {
            this.replicaSpecifications = ReplicaAutoScalingSpecificationListCopier.copy(replicaSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaSpecifications(ReplicaAutoScalingSpecification ... replicaSpecifications) {
            this.replicaSpecifications(Arrays.asList(replicaSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaSpecifications(Consumer<ReplicaAutoScalingSpecification.Builder> ... replicaSpecifications) {
            this.replicaSpecifications(Stream.of(replicaSpecifications).map(c -> (ReplicaAutoScalingSpecification)((ReplicaAutoScalingSpecification.Builder)ReplicaAutoScalingSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetTableAutoScalingSettingsResponse build() {
            return new GetTableAutoScalingSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KeyspacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTableAutoScalingSettingsResponse> {
        public Builder keyspaceName(String var1);

        public Builder tableName(String var1);

        public Builder resourceArn(String var1);

        public Builder autoScalingSpecification(AutoScalingSpecification var1);

        default public Builder autoScalingSpecification(Consumer<AutoScalingSpecification.Builder> autoScalingSpecification) {
            return this.autoScalingSpecification((AutoScalingSpecification)((AutoScalingSpecification.Builder)AutoScalingSpecification.builder().applyMutation(autoScalingSpecification)).build());
        }

        public Builder replicaSpecifications(Collection<ReplicaAutoScalingSpecification> var1);

        public Builder replicaSpecifications(ReplicaAutoScalingSpecification ... var1);

        public Builder replicaSpecifications(Consumer<ReplicaAutoScalingSpecification.Builder> ... var1);
    }
}

