/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.keyspaces.model.ClusteringKey;
import software.amazon.awssdk.services.keyspaces.model.ClusteringKeyListCopier;
import software.amazon.awssdk.services.keyspaces.model.ColumnDefinition;
import software.amazon.awssdk.services.keyspaces.model.ColumnDefinitionListCopier;
import software.amazon.awssdk.services.keyspaces.model.PartitionKey;
import software.amazon.awssdk.services.keyspaces.model.PartitionKeyListCopier;
import software.amazon.awssdk.services.keyspaces.model.StaticColumn;
import software.amazon.awssdk.services.keyspaces.model.StaticColumnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaDefinition> {
    private static final SdkField<List<ColumnDefinition>> ALL_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allColumns").getter(SchemaDefinition.getter(SchemaDefinition::allColumns)).setter(SchemaDefinition.setter(Builder::allColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PartitionKey>> PARTITION_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("partitionKeys").getter(SchemaDefinition.getter(SchemaDefinition::partitionKeys)).setter(SchemaDefinition.setter(Builder::partitionKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partitionKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PartitionKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ClusteringKey>> CLUSTERING_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("clusteringKeys").getter(SchemaDefinition.getter(SchemaDefinition::clusteringKeys)).setter(SchemaDefinition.setter(Builder::clusteringKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusteringKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusteringKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StaticColumn>> STATIC_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("staticColumns").getter(SchemaDefinition.getter(SchemaDefinition::staticColumns)).setter(SchemaDefinition.setter(Builder::staticColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StaticColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_COLUMNS_FIELD, PARTITION_KEYS_FIELD, CLUSTERING_KEYS_FIELD, STATIC_COLUMNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ColumnDefinition> allColumns;
    private final List<PartitionKey> partitionKeys;
    private final List<ClusteringKey> clusteringKeys;
    private final List<StaticColumn> staticColumns;

    private SchemaDefinition(BuilderImpl builder) {
        this.allColumns = builder.allColumns;
        this.partitionKeys = builder.partitionKeys;
        this.clusteringKeys = builder.clusteringKeys;
        this.staticColumns = builder.staticColumns;
    }

    public final boolean hasAllColumns() {
        return this.allColumns != null && !(this.allColumns instanceof SdkAutoConstructList);
    }

    public final List<ColumnDefinition> allColumns() {
        return this.allColumns;
    }

    public final boolean hasPartitionKeys() {
        return this.partitionKeys != null && !(this.partitionKeys instanceof SdkAutoConstructList);
    }

    public final List<PartitionKey> partitionKeys() {
        return this.partitionKeys;
    }

    public final boolean hasClusteringKeys() {
        return this.clusteringKeys != null && !(this.clusteringKeys instanceof SdkAutoConstructList);
    }

    public final List<ClusteringKey> clusteringKeys() {
        return this.clusteringKeys;
    }

    public final boolean hasStaticColumns() {
        return this.staticColumns != null && !(this.staticColumns instanceof SdkAutoConstructList);
    }

    public final List<StaticColumn> staticColumns() {
        return this.staticColumns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllColumns() ? this.allColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionKeys() ? this.partitionKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusteringKeys() ? this.clusteringKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStaticColumns() ? this.staticColumns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaDefinition)) {
            return false;
        }
        SchemaDefinition other = (SchemaDefinition)obj;
        return this.hasAllColumns() == other.hasAllColumns() && Objects.equals(this.allColumns(), other.allColumns()) && this.hasPartitionKeys() == other.hasPartitionKeys() && Objects.equals(this.partitionKeys(), other.partitionKeys()) && this.hasClusteringKeys() == other.hasClusteringKeys() && Objects.equals(this.clusteringKeys(), other.clusteringKeys()) && this.hasStaticColumns() == other.hasStaticColumns() && Objects.equals(this.staticColumns(), other.staticColumns());
    }

    public final String toString() {
        return ToString.builder((String)"SchemaDefinition").add("AllColumns", this.hasAllColumns() ? this.allColumns() : null).add("PartitionKeys", this.hasPartitionKeys() ? this.partitionKeys() : null).add("ClusteringKeys", this.hasClusteringKeys() ? this.clusteringKeys() : null).add("StaticColumns", this.hasStaticColumns() ? this.staticColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allColumns": {
                return Optional.ofNullable(clazz.cast(this.allColumns()));
            }
            case "partitionKeys": {
                return Optional.ofNullable(clazz.cast(this.partitionKeys()));
            }
            case "clusteringKeys": {
                return Optional.ofNullable(clazz.cast(this.clusteringKeys()));
            }
            case "staticColumns": {
                return Optional.ofNullable(clazz.cast(this.staticColumns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaDefinition, T> g) {
        return obj -> g.apply((SchemaDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ColumnDefinition> allColumns = DefaultSdkAutoConstructList.getInstance();
        private List<PartitionKey> partitionKeys = DefaultSdkAutoConstructList.getInstance();
        private List<ClusteringKey> clusteringKeys = DefaultSdkAutoConstructList.getInstance();
        private List<StaticColumn> staticColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaDefinition model) {
            this.allColumns(model.allColumns);
            this.partitionKeys(model.partitionKeys);
            this.clusteringKeys(model.clusteringKeys);
            this.staticColumns(model.staticColumns);
        }

        public final List<ColumnDefinition.Builder> getAllColumns() {
            List<ColumnDefinition.Builder> result = ColumnDefinitionListCopier.copyToBuilder(this.allColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllColumns(Collection<ColumnDefinition.BuilderImpl> allColumns) {
            this.allColumns = ColumnDefinitionListCopier.copyFromBuilder(allColumns);
        }

        @Override
        public final Builder allColumns(Collection<ColumnDefinition> allColumns) {
            this.allColumns = ColumnDefinitionListCopier.copy(allColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allColumns(ColumnDefinition ... allColumns) {
            this.allColumns(Arrays.asList(allColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allColumns(Consumer<ColumnDefinition.Builder> ... allColumns) {
            this.allColumns(Stream.of(allColumns).map(c -> (ColumnDefinition)((ColumnDefinition.Builder)ColumnDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PartitionKey.Builder> getPartitionKeys() {
            List<PartitionKey.Builder> result = PartitionKeyListCopier.copyToBuilder(this.partitionKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartitionKeys(Collection<PartitionKey.BuilderImpl> partitionKeys) {
            this.partitionKeys = PartitionKeyListCopier.copyFromBuilder(partitionKeys);
        }

        @Override
        public final Builder partitionKeys(Collection<PartitionKey> partitionKeys) {
            this.partitionKeys = PartitionKeyListCopier.copy(partitionKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(PartitionKey ... partitionKeys) {
            this.partitionKeys(Arrays.asList(partitionKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(Consumer<PartitionKey.Builder> ... partitionKeys) {
            this.partitionKeys(Stream.of(partitionKeys).map(c -> (PartitionKey)((PartitionKey.Builder)PartitionKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ClusteringKey.Builder> getClusteringKeys() {
            List<ClusteringKey.Builder> result = ClusteringKeyListCopier.copyToBuilder(this.clusteringKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusteringKeys(Collection<ClusteringKey.BuilderImpl> clusteringKeys) {
            this.clusteringKeys = ClusteringKeyListCopier.copyFromBuilder(clusteringKeys);
        }

        @Override
        public final Builder clusteringKeys(Collection<ClusteringKey> clusteringKeys) {
            this.clusteringKeys = ClusteringKeyListCopier.copy(clusteringKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusteringKeys(ClusteringKey ... clusteringKeys) {
            this.clusteringKeys(Arrays.asList(clusteringKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusteringKeys(Consumer<ClusteringKey.Builder> ... clusteringKeys) {
            this.clusteringKeys(Stream.of(clusteringKeys).map(c -> (ClusteringKey)((ClusteringKey.Builder)ClusteringKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StaticColumn.Builder> getStaticColumns() {
            List<StaticColumn.Builder> result = StaticColumnListCopier.copyToBuilder(this.staticColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStaticColumns(Collection<StaticColumn.BuilderImpl> staticColumns) {
            this.staticColumns = StaticColumnListCopier.copyFromBuilder(staticColumns);
        }

        @Override
        public final Builder staticColumns(Collection<StaticColumn> staticColumns) {
            this.staticColumns = StaticColumnListCopier.copy(staticColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticColumns(StaticColumn ... staticColumns) {
            this.staticColumns(Arrays.asList(staticColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticColumns(Consumer<StaticColumn.Builder> ... staticColumns) {
            this.staticColumns(Stream.of(staticColumns).map(c -> (StaticColumn)((StaticColumn.Builder)StaticColumn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SchemaDefinition build() {
            return new SchemaDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaDefinition> {
        public Builder allColumns(Collection<ColumnDefinition> var1);

        public Builder allColumns(ColumnDefinition ... var1);

        public Builder allColumns(Consumer<ColumnDefinition.Builder> ... var1);

        public Builder partitionKeys(Collection<PartitionKey> var1);

        public Builder partitionKeys(PartitionKey ... var1);

        public Builder partitionKeys(Consumer<PartitionKey.Builder> ... var1);

        public Builder clusteringKeys(Collection<ClusteringKey> var1);

        public Builder clusteringKeys(ClusteringKey ... var1);

        public Builder clusteringKeys(Consumer<ClusteringKey.Builder> ... var1);

        public Builder staticColumns(Collection<StaticColumn> var1);

        public Builder staticColumns(StaticColumn ... var1);

        public Builder staticColumns(Consumer<StaticColumn.Builder> ... var1);
    }
}

