/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.keyspaces.KeyspacesAsyncClient;
import software.amazon.awssdk.services.keyspaces.model.KeyspaceSummary;
import software.amazon.awssdk.services.keyspaces.model.ListKeyspacesRequest;
import software.amazon.awssdk.services.keyspaces.model.ListKeyspacesResponse;

public class ListKeyspacesPublisher
implements SdkPublisher<ListKeyspacesResponse> {
    private final KeyspacesAsyncClient client;
    private final ListKeyspacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListKeyspacesPublisher(KeyspacesAsyncClient client, ListKeyspacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListKeyspacesPublisher(KeyspacesAsyncClient client, ListKeyspacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListKeyspacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListKeyspacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<KeyspaceSummary> keyspaces() {
        Function<ListKeyspacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.keyspaces() != null) {
                return response.keyspaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListKeyspacesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListKeyspacesResponseFetcher
    implements AsyncPageFetcher<ListKeyspacesResponse> {
        private ListKeyspacesResponseFetcher() {
        }

        public boolean hasNextPage(ListKeyspacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListKeyspacesResponse> nextPage(ListKeyspacesResponse previousPage) {
            if (previousPage == null) {
                return ListKeyspacesPublisher.this.client.listKeyspaces(ListKeyspacesPublisher.this.firstRequest);
            }
            return ListKeyspacesPublisher.this.client.listKeyspaces((ListKeyspacesRequest)((Object)ListKeyspacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

