/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DataSourceInclusionsExclusionsStringsCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMappingListCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceVpcConfiguration;
import software.amazon.awssdk.services.kendra.model.FolderIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuipConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuipConfiguration> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(QuipConfiguration.getter(QuipConfiguration::domain)).setter(QuipConfiguration.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(QuipConfiguration.getter(QuipConfiguration::secretArn)).setter(QuipConfiguration.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<Boolean> CRAWL_FILE_COMMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CrawlFileComments").getter(QuipConfiguration.getter(QuipConfiguration::crawlFileComments)).setter(QuipConfiguration.setter(Builder::crawlFileComments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlFileComments").build()}).build();
    private static final SdkField<Boolean> CRAWL_CHAT_ROOMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CrawlChatRooms").getter(QuipConfiguration.getter(QuipConfiguration::crawlChatRooms)).setter(QuipConfiguration.setter(Builder::crawlChatRooms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlChatRooms").build()}).build();
    private static final SdkField<Boolean> CRAWL_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CrawlAttachments").getter(QuipConfiguration.getter(QuipConfiguration::crawlAttachments)).setter(QuipConfiguration.setter(Builder::crawlAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlAttachments").build()}).build();
    private static final SdkField<List<String>> FOLDER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FolderIds").getter(QuipConfiguration.getter(QuipConfiguration::folderIds)).setter(QuipConfiguration.setter(Builder::folderIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> THREAD_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ThreadFieldMappings").getter(QuipConfiguration.getter(QuipConfiguration::threadFieldMappings)).setter(QuipConfiguration.setter(Builder::threadFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> MESSAGE_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MessageFieldMappings").getter(QuipConfiguration.getter(QuipConfiguration::messageFieldMappings)).setter(QuipConfiguration.setter(Builder::messageFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> ATTACHMENT_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttachmentFieldMappings").getter(QuipConfiguration.getter(QuipConfiguration::attachmentFieldMappings)).setter(QuipConfiguration.setter(Builder::attachmentFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InclusionPatterns").getter(QuipConfiguration.getter(QuipConfiguration::inclusionPatterns)).setter(QuipConfiguration.setter(Builder::inclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExclusionPatterns").getter(QuipConfiguration.getter(QuipConfiguration::exclusionPatterns)).setter(QuipConfiguration.setter(Builder::exclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfiguration").getter(QuipConfiguration.getter(QuipConfiguration::vpcConfiguration)).setter(QuipConfiguration.setter(Builder::vpcConfiguration)).constructor(DataSourceVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, SECRET_ARN_FIELD, CRAWL_FILE_COMMENTS_FIELD, CRAWL_CHAT_ROOMS_FIELD, CRAWL_ATTACHMENTS_FIELD, FOLDER_IDS_FIELD, THREAD_FIELD_MAPPINGS_FIELD, MESSAGE_FIELD_MAPPINGS_FIELD, ATTACHMENT_FIELD_MAPPINGS_FIELD, INCLUSION_PATTERNS_FIELD, EXCLUSION_PATTERNS_FIELD, VPC_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domain;
    private final String secretArn;
    private final Boolean crawlFileComments;
    private final Boolean crawlChatRooms;
    private final Boolean crawlAttachments;
    private final List<String> folderIds;
    private final List<DataSourceToIndexFieldMapping> threadFieldMappings;
    private final List<DataSourceToIndexFieldMapping> messageFieldMappings;
    private final List<DataSourceToIndexFieldMapping> attachmentFieldMappings;
    private final List<String> inclusionPatterns;
    private final List<String> exclusionPatterns;
    private final DataSourceVpcConfiguration vpcConfiguration;

    private QuipConfiguration(BuilderImpl builder) {
        this.domain = builder.domain;
        this.secretArn = builder.secretArn;
        this.crawlFileComments = builder.crawlFileComments;
        this.crawlChatRooms = builder.crawlChatRooms;
        this.crawlAttachments = builder.crawlAttachments;
        this.folderIds = builder.folderIds;
        this.threadFieldMappings = builder.threadFieldMappings;
        this.messageFieldMappings = builder.messageFieldMappings;
        this.attachmentFieldMappings = builder.attachmentFieldMappings;
        this.inclusionPatterns = builder.inclusionPatterns;
        this.exclusionPatterns = builder.exclusionPatterns;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    public final String domain() {
        return this.domain;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final Boolean crawlFileComments() {
        return this.crawlFileComments;
    }

    public final Boolean crawlChatRooms() {
        return this.crawlChatRooms;
    }

    public final Boolean crawlAttachments() {
        return this.crawlAttachments;
    }

    public final boolean hasFolderIds() {
        return this.folderIds != null && !(this.folderIds instanceof SdkAutoConstructList);
    }

    public final List<String> folderIds() {
        return this.folderIds;
    }

    public final boolean hasThreadFieldMappings() {
        return this.threadFieldMappings != null && !(this.threadFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> threadFieldMappings() {
        return this.threadFieldMappings;
    }

    public final boolean hasMessageFieldMappings() {
        return this.messageFieldMappings != null && !(this.messageFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> messageFieldMappings() {
        return this.messageFieldMappings;
    }

    public final boolean hasAttachmentFieldMappings() {
        return this.attachmentFieldMappings != null && !(this.attachmentFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> attachmentFieldMappings() {
        return this.attachmentFieldMappings;
    }

    public final boolean hasInclusionPatterns() {
        return this.inclusionPatterns != null && !(this.inclusionPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> inclusionPatterns() {
        return this.inclusionPatterns;
    }

    public final boolean hasExclusionPatterns() {
        return this.exclusionPatterns != null && !(this.exclusionPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> exclusionPatterns() {
        return this.exclusionPatterns;
    }

    public final DataSourceVpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlFileComments());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlChatRooms());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFolderIds() ? this.folderIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThreadFieldMappings() ? this.threadFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessageFieldMappings() ? this.messageFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachmentFieldMappings() ? this.attachmentFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionPatterns() ? this.inclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionPatterns() ? this.exclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuipConfiguration)) {
            return false;
        }
        QuipConfiguration other = (QuipConfiguration)obj;
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.crawlFileComments(), other.crawlFileComments()) && Objects.equals(this.crawlChatRooms(), other.crawlChatRooms()) && Objects.equals(this.crawlAttachments(), other.crawlAttachments()) && this.hasFolderIds() == other.hasFolderIds() && Objects.equals(this.folderIds(), other.folderIds()) && this.hasThreadFieldMappings() == other.hasThreadFieldMappings() && Objects.equals(this.threadFieldMappings(), other.threadFieldMappings()) && this.hasMessageFieldMappings() == other.hasMessageFieldMappings() && Objects.equals(this.messageFieldMappings(), other.messageFieldMappings()) && this.hasAttachmentFieldMappings() == other.hasAttachmentFieldMappings() && Objects.equals(this.attachmentFieldMappings(), other.attachmentFieldMappings()) && this.hasInclusionPatterns() == other.hasInclusionPatterns() && Objects.equals(this.inclusionPatterns(), other.inclusionPatterns()) && this.hasExclusionPatterns() == other.hasExclusionPatterns() && Objects.equals(this.exclusionPatterns(), other.exclusionPatterns()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"QuipConfiguration").add("Domain", (Object)this.domain()).add("SecretArn", (Object)this.secretArn()).add("CrawlFileComments", (Object)this.crawlFileComments()).add("CrawlChatRooms", (Object)this.crawlChatRooms()).add("CrawlAttachments", (Object)this.crawlAttachments()).add("FolderIds", this.hasFolderIds() ? this.folderIds() : null).add("ThreadFieldMappings", this.hasThreadFieldMappings() ? this.threadFieldMappings() : null).add("MessageFieldMappings", this.hasMessageFieldMappings() ? this.messageFieldMappings() : null).add("AttachmentFieldMappings", this.hasAttachmentFieldMappings() ? this.attachmentFieldMappings() : null).add("InclusionPatterns", this.hasInclusionPatterns() ? this.inclusionPatterns() : null).add("ExclusionPatterns", this.hasExclusionPatterns() ? this.exclusionPatterns() : null).add("VpcConfiguration", (Object)this.vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "CrawlFileComments": {
                return Optional.ofNullable(clazz.cast(this.crawlFileComments()));
            }
            case "CrawlChatRooms": {
                return Optional.ofNullable(clazz.cast(this.crawlChatRooms()));
            }
            case "CrawlAttachments": {
                return Optional.ofNullable(clazz.cast(this.crawlAttachments()));
            }
            case "FolderIds": {
                return Optional.ofNullable(clazz.cast(this.folderIds()));
            }
            case "ThreadFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.threadFieldMappings()));
            }
            case "MessageFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.messageFieldMappings()));
            }
            case "AttachmentFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.attachmentFieldMappings()));
            }
            case "InclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.inclusionPatterns()));
            }
            case "ExclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.exclusionPatterns()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QuipConfiguration, T> g) {
        return obj -> g.apply((QuipConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domain;
        private String secretArn;
        private Boolean crawlFileComments;
        private Boolean crawlChatRooms;
        private Boolean crawlAttachments;
        private List<String> folderIds = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> threadFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> messageFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> attachmentFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<String> inclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> exclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private DataSourceVpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(QuipConfiguration model) {
            this.domain(model.domain);
            this.secretArn(model.secretArn);
            this.crawlFileComments(model.crawlFileComments);
            this.crawlChatRooms(model.crawlChatRooms);
            this.crawlAttachments(model.crawlAttachments);
            this.folderIds(model.folderIds);
            this.threadFieldMappings(model.threadFieldMappings);
            this.messageFieldMappings(model.messageFieldMappings);
            this.attachmentFieldMappings(model.attachmentFieldMappings);
            this.inclusionPatterns(model.inclusionPatterns);
            this.exclusionPatterns(model.exclusionPatterns);
            this.vpcConfiguration(model.vpcConfiguration);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final Boolean getCrawlFileComments() {
            return this.crawlFileComments;
        }

        public final void setCrawlFileComments(Boolean crawlFileComments) {
            this.crawlFileComments = crawlFileComments;
        }

        @Override
        public final Builder crawlFileComments(Boolean crawlFileComments) {
            this.crawlFileComments = crawlFileComments;
            return this;
        }

        public final Boolean getCrawlChatRooms() {
            return this.crawlChatRooms;
        }

        public final void setCrawlChatRooms(Boolean crawlChatRooms) {
            this.crawlChatRooms = crawlChatRooms;
        }

        @Override
        public final Builder crawlChatRooms(Boolean crawlChatRooms) {
            this.crawlChatRooms = crawlChatRooms;
            return this;
        }

        public final Boolean getCrawlAttachments() {
            return this.crawlAttachments;
        }

        public final void setCrawlAttachments(Boolean crawlAttachments) {
            this.crawlAttachments = crawlAttachments;
        }

        @Override
        public final Builder crawlAttachments(Boolean crawlAttachments) {
            this.crawlAttachments = crawlAttachments;
            return this;
        }

        public final Collection<String> getFolderIds() {
            if (this.folderIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.folderIds;
        }

        public final void setFolderIds(Collection<String> folderIds) {
            this.folderIds = FolderIdListCopier.copy(folderIds);
        }

        @Override
        public final Builder folderIds(Collection<String> folderIds) {
            this.folderIds = FolderIdListCopier.copy(folderIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folderIds(String ... folderIds) {
            this.folderIds(Arrays.asList(folderIds));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getThreadFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.threadFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreadFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> threadFieldMappings) {
            this.threadFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(threadFieldMappings);
        }

        @Override
        public final Builder threadFieldMappings(Collection<DataSourceToIndexFieldMapping> threadFieldMappings) {
            this.threadFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(threadFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threadFieldMappings(DataSourceToIndexFieldMapping ... threadFieldMappings) {
            this.threadFieldMappings(Arrays.asList(threadFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threadFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... threadFieldMappings) {
            this.threadFieldMappings(Stream.of(threadFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getMessageFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.messageFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessageFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> messageFieldMappings) {
            this.messageFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(messageFieldMappings);
        }

        @Override
        public final Builder messageFieldMappings(Collection<DataSourceToIndexFieldMapping> messageFieldMappings) {
            this.messageFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(messageFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageFieldMappings(DataSourceToIndexFieldMapping ... messageFieldMappings) {
            this.messageFieldMappings(Arrays.asList(messageFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... messageFieldMappings) {
            this.messageFieldMappings(Stream.of(messageFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getAttachmentFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.attachmentFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachmentFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> attachmentFieldMappings) {
            this.attachmentFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(attachmentFieldMappings);
        }

        @Override
        public final Builder attachmentFieldMappings(Collection<DataSourceToIndexFieldMapping> attachmentFieldMappings) {
            this.attachmentFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(attachmentFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentFieldMappings(DataSourceToIndexFieldMapping ... attachmentFieldMappings) {
            this.attachmentFieldMappings(Arrays.asList(attachmentFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... attachmentFieldMappings) {
            this.attachmentFieldMappings(Stream.of(attachmentFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getInclusionPatterns() {
            if (this.inclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inclusionPatterns;
        }

        public final void setInclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
        }

        @Override
        public final Builder inclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionPatterns(String ... inclusionPatterns) {
            this.inclusionPatterns(Arrays.asList(inclusionPatterns));
            return this;
        }

        public final Collection<String> getExclusionPatterns() {
            if (this.exclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusionPatterns;
        }

        public final void setExclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
        }

        @Override
        public final Builder exclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPatterns(String ... exclusionPatterns) {
            this.exclusionPatterns(Arrays.asList(exclusionPatterns));
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public QuipConfiguration build() {
            return new QuipConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuipConfiguration> {
        public Builder domain(String var1);

        public Builder secretArn(String var1);

        public Builder crawlFileComments(Boolean var1);

        public Builder crawlChatRooms(Boolean var1);

        public Builder crawlAttachments(Boolean var1);

        public Builder folderIds(Collection<String> var1);

        public Builder folderIds(String ... var1);

        public Builder threadFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder threadFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder threadFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder messageFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder messageFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder messageFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder attachmentFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder attachmentFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder attachmentFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder inclusionPatterns(Collection<String> var1);

        public Builder inclusionPatterns(String ... var1);

        public Builder exclusionPatterns(Collection<String> var1);

        public Builder exclusionPatterns(String ... var1);

        public Builder vpcConfiguration(DataSourceVpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((DataSourceVpcConfiguration)((DataSourceVpcConfiguration.Builder)DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }
    }
}

