/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.OneDriveUserListCopier;
import software.amazon.awssdk.services.kendra.model.S3Path;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OneDriveUsers
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OneDriveUsers> {
    private static final SdkField<List<String>> ONE_DRIVE_USER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OneDriveUserList").getter(OneDriveUsers.getter(OneDriveUsers::oneDriveUserList)).setter(OneDriveUsers.setter(Builder::oneDriveUserList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OneDriveUserList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<S3Path> ONE_DRIVE_USER_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OneDriveUserS3Path").getter(OneDriveUsers.getter(OneDriveUsers::oneDriveUserS3Path)).setter(OneDriveUsers.setter(Builder::oneDriveUserS3Path)).constructor(S3Path::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OneDriveUserS3Path").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ONE_DRIVE_USER_LIST_FIELD, ONE_DRIVE_USER_S3_PATH_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> oneDriveUserList;
    private final S3Path oneDriveUserS3Path;

    private OneDriveUsers(BuilderImpl builder) {
        this.oneDriveUserList = builder.oneDriveUserList;
        this.oneDriveUserS3Path = builder.oneDriveUserS3Path;
    }

    public final boolean hasOneDriveUserList() {
        return this.oneDriveUserList != null && !(this.oneDriveUserList instanceof SdkAutoConstructList);
    }

    public final List<String> oneDriveUserList() {
        return this.oneDriveUserList;
    }

    public final S3Path oneDriveUserS3Path() {
        return this.oneDriveUserS3Path;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOneDriveUserList() ? this.oneDriveUserList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.oneDriveUserS3Path());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OneDriveUsers)) {
            return false;
        }
        OneDriveUsers other = (OneDriveUsers)obj;
        return this.hasOneDriveUserList() == other.hasOneDriveUserList() && Objects.equals(this.oneDriveUserList(), other.oneDriveUserList()) && Objects.equals(this.oneDriveUserS3Path(), other.oneDriveUserS3Path());
    }

    public final String toString() {
        return ToString.builder((String)"OneDriveUsers").add("OneDriveUserList", this.hasOneDriveUserList() ? this.oneDriveUserList() : null).add("OneDriveUserS3Path", (Object)this.oneDriveUserS3Path()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OneDriveUserList": {
                return Optional.ofNullable(clazz.cast(this.oneDriveUserList()));
            }
            case "OneDriveUserS3Path": {
                return Optional.ofNullable(clazz.cast(this.oneDriveUserS3Path()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OneDriveUsers, T> g) {
        return obj -> g.apply((OneDriveUsers)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> oneDriveUserList = DefaultSdkAutoConstructList.getInstance();
        private S3Path oneDriveUserS3Path;

        private BuilderImpl() {
        }

        private BuilderImpl(OneDriveUsers model) {
            this.oneDriveUserList(model.oneDriveUserList);
            this.oneDriveUserS3Path(model.oneDriveUserS3Path);
        }

        public final Collection<String> getOneDriveUserList() {
            if (this.oneDriveUserList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.oneDriveUserList;
        }

        public final void setOneDriveUserList(Collection<String> oneDriveUserList) {
            this.oneDriveUserList = OneDriveUserListCopier.copy(oneDriveUserList);
        }

        @Override
        public final Builder oneDriveUserList(Collection<String> oneDriveUserList) {
            this.oneDriveUserList = OneDriveUserListCopier.copy(oneDriveUserList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder oneDriveUserList(String ... oneDriveUserList) {
            this.oneDriveUserList(Arrays.asList(oneDriveUserList));
            return this;
        }

        public final S3Path.Builder getOneDriveUserS3Path() {
            return this.oneDriveUserS3Path != null ? this.oneDriveUserS3Path.toBuilder() : null;
        }

        public final void setOneDriveUserS3Path(S3Path.BuilderImpl oneDriveUserS3Path) {
            this.oneDriveUserS3Path = oneDriveUserS3Path != null ? oneDriveUserS3Path.build() : null;
        }

        @Override
        public final Builder oneDriveUserS3Path(S3Path oneDriveUserS3Path) {
            this.oneDriveUserS3Path = oneDriveUserS3Path;
            return this;
        }

        public OneDriveUsers build() {
            return new OneDriveUsers(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OneDriveUsers> {
        public Builder oneDriveUserList(Collection<String> var1);

        public Builder oneDriveUserList(String ... var1);

        public Builder oneDriveUserS3Path(S3Path var1);

        default public Builder oneDriveUserS3Path(Consumer<S3Path.Builder> oneDriveUserS3Path) {
            return this.oneDriveUserS3Path((S3Path)((S3Path.Builder)S3Path.builder().applyMutation(oneDriveUserS3Path)).build());
        }
    }
}

