/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ParticipantProtocol {
    UNKNOWN("UNKNOWN"),
    WHIP("WHIP"),
    RTMP("RTMP"),
    RTMPS("RTMPS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ParticipantProtocol> VALUE_MAP;
    private final String value;

    private ParticipantProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ParticipantProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ParticipantProtocol> knownValues() {
        EnumSet<ParticipantProtocol> knownValues = EnumSet.allOf(ParticipantProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ParticipantProtocol.class, ParticipantProtocol::toString);
    }
}

