/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantRecordingMediaType;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantRecordingMediaTypeListCopier;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantThumbnailConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoParticipantRecordingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoParticipantRecordingConfiguration> {
    private static final SdkField<String> STORAGE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageConfigurationArn").getter(AutoParticipantRecordingConfiguration.getter(AutoParticipantRecordingConfiguration::storageConfigurationArn)).setter(AutoParticipantRecordingConfiguration.setter(Builder::storageConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfigurationArn").build()}).build();
    private static final SdkField<List<String>> MEDIA_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mediaTypes").getter(AutoParticipantRecordingConfiguration.getter(AutoParticipantRecordingConfiguration::mediaTypesAsStrings)).setter(AutoParticipantRecordingConfiguration.setter(Builder::mediaTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ParticipantThumbnailConfiguration> THUMBNAIL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("thumbnailConfiguration").getter(AutoParticipantRecordingConfiguration.getter(AutoParticipantRecordingConfiguration::thumbnailConfiguration)).setter(AutoParticipantRecordingConfiguration.setter(Builder::thumbnailConfiguration)).constructor(ParticipantThumbnailConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_CONFIGURATION_ARN_FIELD, MEDIA_TYPES_FIELD, THUMBNAIL_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("storageConfigurationArn", STORAGE_CONFIGURATION_ARN_FIELD);
            this.put("mediaTypes", MEDIA_TYPES_FIELD);
            this.put("thumbnailConfiguration", THUMBNAIL_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String storageConfigurationArn;
    private final List<String> mediaTypes;
    private final ParticipantThumbnailConfiguration thumbnailConfiguration;

    private AutoParticipantRecordingConfiguration(BuilderImpl builder) {
        this.storageConfigurationArn = builder.storageConfigurationArn;
        this.mediaTypes = builder.mediaTypes;
        this.thumbnailConfiguration = builder.thumbnailConfiguration;
    }

    public final String storageConfigurationArn() {
        return this.storageConfigurationArn;
    }

    public final List<ParticipantRecordingMediaType> mediaTypes() {
        return ParticipantRecordingMediaTypeListCopier.copyStringToEnum(this.mediaTypes);
    }

    public final boolean hasMediaTypes() {
        return this.mediaTypes != null && !(this.mediaTypes instanceof SdkAutoConstructList);
    }

    public final List<String> mediaTypesAsStrings() {
        return this.mediaTypes;
    }

    public final ParticipantThumbnailConfiguration thumbnailConfiguration() {
        return this.thumbnailConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaTypes() ? this.mediaTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnailConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoParticipantRecordingConfiguration)) {
            return false;
        }
        AutoParticipantRecordingConfiguration other = (AutoParticipantRecordingConfiguration)obj;
        return Objects.equals(this.storageConfigurationArn(), other.storageConfigurationArn()) && this.hasMediaTypes() == other.hasMediaTypes() && Objects.equals(this.mediaTypesAsStrings(), other.mediaTypesAsStrings()) && Objects.equals(this.thumbnailConfiguration(), other.thumbnailConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"AutoParticipantRecordingConfiguration").add("StorageConfigurationArn", (Object)this.storageConfigurationArn()).add("MediaTypes", this.hasMediaTypes() ? this.mediaTypesAsStrings() : null).add("ThumbnailConfiguration", (Object)this.thumbnailConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "storageConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.storageConfigurationArn()));
            }
            case "mediaTypes": {
                return Optional.ofNullable(clazz.cast(this.mediaTypesAsStrings()));
            }
            case "thumbnailConfiguration": {
                return Optional.ofNullable(clazz.cast(this.thumbnailConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AutoParticipantRecordingConfiguration, T> g) {
        return obj -> g.apply((AutoParticipantRecordingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String storageConfigurationArn;
        private List<String> mediaTypes = DefaultSdkAutoConstructList.getInstance();
        private ParticipantThumbnailConfiguration thumbnailConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoParticipantRecordingConfiguration model) {
            this.storageConfigurationArn(model.storageConfigurationArn);
            this.mediaTypesWithStrings(model.mediaTypes);
            this.thumbnailConfiguration(model.thumbnailConfiguration);
        }

        public final String getStorageConfigurationArn() {
            return this.storageConfigurationArn;
        }

        public final void setStorageConfigurationArn(String storageConfigurationArn) {
            this.storageConfigurationArn = storageConfigurationArn;
        }

        @Override
        public final Builder storageConfigurationArn(String storageConfigurationArn) {
            this.storageConfigurationArn = storageConfigurationArn;
            return this;
        }

        public final Collection<String> getMediaTypes() {
            if (this.mediaTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.mediaTypes;
        }

        public final void setMediaTypes(Collection<String> mediaTypes) {
            this.mediaTypes = ParticipantRecordingMediaTypeListCopier.copy(mediaTypes);
        }

        @Override
        public final Builder mediaTypesWithStrings(Collection<String> mediaTypes) {
            this.mediaTypes = ParticipantRecordingMediaTypeListCopier.copy(mediaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaTypesWithStrings(String ... mediaTypes) {
            this.mediaTypesWithStrings(Arrays.asList(mediaTypes));
            return this;
        }

        @Override
        public final Builder mediaTypes(Collection<ParticipantRecordingMediaType> mediaTypes) {
            this.mediaTypes = ParticipantRecordingMediaTypeListCopier.copyEnumToString(mediaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaTypes(ParticipantRecordingMediaType ... mediaTypes) {
            this.mediaTypes(Arrays.asList(mediaTypes));
            return this;
        }

        public final ParticipantThumbnailConfiguration.Builder getThumbnailConfiguration() {
            return this.thumbnailConfiguration != null ? this.thumbnailConfiguration.toBuilder() : null;
        }

        public final void setThumbnailConfiguration(ParticipantThumbnailConfiguration.BuilderImpl thumbnailConfiguration) {
            this.thumbnailConfiguration = thumbnailConfiguration != null ? thumbnailConfiguration.build() : null;
        }

        @Override
        public final Builder thumbnailConfiguration(ParticipantThumbnailConfiguration thumbnailConfiguration) {
            this.thumbnailConfiguration = thumbnailConfiguration;
            return this;
        }

        public AutoParticipantRecordingConfiguration build() {
            return new AutoParticipantRecordingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoParticipantRecordingConfiguration> {
        public Builder storageConfigurationArn(String var1);

        public Builder mediaTypesWithStrings(Collection<String> var1);

        public Builder mediaTypesWithStrings(String ... var1);

        public Builder mediaTypes(Collection<ParticipantRecordingMediaType> var1);

        public Builder mediaTypes(ParticipantRecordingMediaType ... var1);

        public Builder thumbnailConfiguration(ParticipantThumbnailConfiguration var1);

        default public Builder thumbnailConfiguration(Consumer<ParticipantThumbnailConfiguration.Builder> thumbnailConfiguration) {
            return this.thumbnailConfiguration((ParticipantThumbnailConfiguration)((ParticipantThumbnailConfiguration.Builder)ParticipantThumbnailConfiguration.builder().applyMutation(thumbnailConfiguration)).build());
        }
    }
}

