/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.AggregationPeriod;
import software.amazon.awssdk.services.iotwireless.model.Dimension;
import software.amazon.awssdk.services.iotwireless.model.DimensionsCopier;
import software.amazon.awssdk.services.iotwireless.model.MetricName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SummaryMetricQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SummaryMetricQuery> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryId").getter(SummaryMetricQuery.getter(SummaryMetricQuery::queryId)).setter(SummaryMetricQuery.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(SummaryMetricQuery.getter(SummaryMetricQuery::metricNameAsString)).setter(SummaryMetricQuery.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<List<Dimension>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dimensions").getter(SummaryMetricQuery.getter(SummaryMetricQuery::dimensions)).setter(SummaryMetricQuery.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Dimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AGGREGATION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AggregationPeriod").getter(SummaryMetricQuery.getter(SummaryMetricQuery::aggregationPeriodAsString)).setter(SummaryMetricQuery.setter(Builder::aggregationPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationPeriod").build()}).build();
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTimestamp").getter(SummaryMetricQuery.getter(SummaryMetricQuery::startTimestamp)).setter(SummaryMetricQuery.setter(Builder::startTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()}).build();
    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTimestamp").getter(SummaryMetricQuery.getter(SummaryMetricQuery::endTimestamp)).setter(SummaryMetricQuery.setter(Builder::endTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD, METRIC_NAME_FIELD, DIMENSIONS_FIELD, AGGREGATION_PERIOD_FIELD, START_TIMESTAMP_FIELD, END_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SummaryMetricQuery.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String queryId;
    private final String metricName;
    private final List<Dimension> dimensions;
    private final String aggregationPeriod;
    private final Instant startTimestamp;
    private final Instant endTimestamp;

    private SummaryMetricQuery(BuilderImpl builder) {
        this.queryId = builder.queryId;
        this.metricName = builder.metricName;
        this.dimensions = builder.dimensions;
        this.aggregationPeriod = builder.aggregationPeriod;
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final MetricName metricName() {
        return MetricName.fromValue(this.metricName);
    }

    public final String metricNameAsString() {
        return this.metricName;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public final List<Dimension> dimensions() {
        return this.dimensions;
    }

    public final AggregationPeriod aggregationPeriod() {
        return AggregationPeriod.fromValue(this.aggregationPeriod);
    }

    public final String aggregationPeriodAsString() {
        return this.aggregationPeriod;
    }

    public final Instant startTimestamp() {
        return this.startTimestamp;
    }

    public final Instant endTimestamp() {
        return this.endTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SummaryMetricQuery)) {
            return false;
        }
        SummaryMetricQuery other = (SummaryMetricQuery)obj;
        return Objects.equals(this.queryId(), other.queryId()) && Objects.equals(this.metricNameAsString(), other.metricNameAsString()) && this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.aggregationPeriodAsString(), other.aggregationPeriodAsString()) && Objects.equals(this.startTimestamp(), other.startTimestamp()) && Objects.equals(this.endTimestamp(), other.endTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"SummaryMetricQuery").add("QueryId", (Object)this.queryId()).add("MetricName", (Object)this.metricNameAsString()).add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("AggregationPeriod", (Object)this.aggregationPeriodAsString()).add("StartTimestamp", (Object)this.startTimestamp()).add("EndTimestamp", (Object)this.endTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricNameAsString()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "AggregationPeriod": {
                return Optional.ofNullable(clazz.cast(this.aggregationPeriodAsString()));
            }
            case "StartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
            case "EndTimestamp": {
                return Optional.ofNullable(clazz.cast(this.endTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("QueryId", QUERY_ID_FIELD);
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("Dimensions", DIMENSIONS_FIELD);
        map.put("AggregationPeriod", AGGREGATION_PERIOD_FIELD);
        map.put("StartTimestamp", START_TIMESTAMP_FIELD);
        map.put("EndTimestamp", END_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SummaryMetricQuery, T> g) {
        return obj -> g.apply((SummaryMetricQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queryId;
        private String metricName;
        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();
        private String aggregationPeriod;
        private Instant startTimestamp;
        private Instant endTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(SummaryMetricQuery model) {
            this.queryId(model.queryId);
            this.metricName(model.metricName);
            this.dimensions(model.dimensions);
            this.aggregationPeriod(model.aggregationPeriod);
            this.startTimestamp(model.startTimestamp);
            this.endTimestamp(model.endTimestamp);
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(MetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final List<Dimension.Builder> getDimensions() {
            List<Dimension.Builder> result = DimensionsCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<Dimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (Dimension)((Dimension.Builder)Dimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAggregationPeriod() {
            return this.aggregationPeriod;
        }

        public final void setAggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
        }

        @Override
        public final Builder aggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
            return this;
        }

        @Override
        public final Builder aggregationPeriod(AggregationPeriod aggregationPeriod) {
            this.aggregationPeriod(aggregationPeriod == null ? null : aggregationPeriod.toString());
            return this;
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getEndTimestamp() {
            return this.endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public SummaryMetricQuery build() {
            return new SummaryMetricQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SummaryMetricQuery> {
        public Builder queryId(String var1);

        public Builder metricName(String var1);

        public Builder metricName(MetricName var1);

        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder dimensions(Consumer<Dimension.Builder> ... var1);

        public Builder aggregationPeriod(String var1);

        public Builder aggregationPeriod(AggregationPeriod var1);

        public Builder startTimestamp(Instant var1);

        public Builder endTimestamp(Instant var1);
    }
}

