/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WirelessGatewayIdType {
    GATEWAY_EUI("GatewayEui"),
    WIRELESS_GATEWAY_ID("WirelessGatewayId"),
    THING_NAME("ThingName"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WirelessGatewayIdType> VALUE_MAP;
    private final String value;

    private WirelessGatewayIdType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WirelessGatewayIdType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WirelessGatewayIdType> knownValues() {
        EnumSet<WirelessGatewayIdType> knownValues = EnumSet.allOf(WirelessGatewayIdType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WirelessGatewayIdType.class, WirelessGatewayIdType::toString);
    }
}

