/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.FuotaTaskEvent;
import software.amazon.awssdk.services.iotwireless.model.LogLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FuotaTaskEventLogOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FuotaTaskEventLogOption> {
    private static final SdkField<String> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Event").getter(FuotaTaskEventLogOption.getter(FuotaTaskEventLogOption::eventAsString)).setter(FuotaTaskEventLogOption.setter(Builder::event)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogLevel").getter(FuotaTaskEventLogOption.getter(FuotaTaskEventLogOption::logLevelAsString)).setter(FuotaTaskEventLogOption.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_FIELD, LOG_LEVEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FuotaTaskEventLogOption.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String event;
    private final String logLevel;

    private FuotaTaskEventLogOption(BuilderImpl builder) {
        this.event = builder.event;
        this.logLevel = builder.logLevel;
    }

    public final FuotaTaskEvent event() {
        return FuotaTaskEvent.fromValue(this.event);
    }

    public final String eventAsString() {
        return this.event;
    }

    public final LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FuotaTaskEventLogOption)) {
            return false;
        }
        FuotaTaskEventLogOption other = (FuotaTaskEventLogOption)obj;
        return Objects.equals(this.eventAsString(), other.eventAsString()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FuotaTaskEventLogOption").add("Event", (Object)this.eventAsString()).add("LogLevel", (Object)this.logLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Event": {
                return Optional.ofNullable(clazz.cast(this.eventAsString()));
            }
            case "LogLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Event", EVENT_FIELD);
        map.put("LogLevel", LOG_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FuotaTaskEventLogOption, T> g) {
        return obj -> g.apply((FuotaTaskEventLogOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String event;
        private String logLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(FuotaTaskEventLogOption model) {
            this.event(model.event);
            this.logLevel(model.logLevel);
        }

        public final String getEvent() {
            return this.event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(FuotaTaskEvent event) {
            this.event(event == null ? null : event.toString());
            return this;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public FuotaTaskEventLogOption build() {
            return new FuotaTaskEventLogOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FuotaTaskEventLogOption> {
        public Builder event(String var1);

        public Builder event(FuotaTaskEvent var1);

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);
    }
}

