/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.FuotaTaskLogOption;
import software.amazon.awssdk.services.iotwireless.model.FuotaTaskLogOptionListCopier;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.LogLevel;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceLogOption;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceLogOptionListCopier;
import software.amazon.awssdk.services.iotwireless.model.WirelessGatewayLogOption;
import software.amazon.awssdk.services.iotwireless.model.WirelessGatewayLogOptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLogLevelsByResourceTypesResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, GetLogLevelsByResourceTypesResponse> {
    private static final SdkField<String> DEFAULT_LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultLogLevel").getter(GetLogLevelsByResourceTypesResponse.getter(GetLogLevelsByResourceTypesResponse::defaultLogLevelAsString)).setter(GetLogLevelsByResourceTypesResponse.setter(Builder::defaultLogLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultLogLevel").build()}).build();
    private static final SdkField<List<WirelessGatewayLogOption>> WIRELESS_GATEWAY_LOG_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WirelessGatewayLogOptions").getter(GetLogLevelsByResourceTypesResponse.getter(GetLogLevelsByResourceTypesResponse::wirelessGatewayLogOptions)).setter(GetLogLevelsByResourceTypesResponse.setter(Builder::wirelessGatewayLogOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGatewayLogOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WirelessGatewayLogOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<WirelessDeviceLogOption>> WIRELESS_DEVICE_LOG_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WirelessDeviceLogOptions").getter(GetLogLevelsByResourceTypesResponse.getter(GetLogLevelsByResourceTypesResponse::wirelessDeviceLogOptions)).setter(GetLogLevelsByResourceTypesResponse.setter(Builder::wirelessDeviceLogOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDeviceLogOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WirelessDeviceLogOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FuotaTaskLogOption>> FUOTA_TASK_LOG_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FuotaTaskLogOptions").getter(GetLogLevelsByResourceTypesResponse.getter(GetLogLevelsByResourceTypesResponse::fuotaTaskLogOptions)).setter(GetLogLevelsByResourceTypesResponse.setter(Builder::fuotaTaskLogOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FuotaTaskLogOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FuotaTaskLogOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_LOG_LEVEL_FIELD, WIRELESS_GATEWAY_LOG_OPTIONS_FIELD, WIRELESS_DEVICE_LOG_OPTIONS_FIELD, FUOTA_TASK_LOG_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLogLevelsByResourceTypesResponse.memberNameToFieldInitializer();
    private final String defaultLogLevel;
    private final List<WirelessGatewayLogOption> wirelessGatewayLogOptions;
    private final List<WirelessDeviceLogOption> wirelessDeviceLogOptions;
    private final List<FuotaTaskLogOption> fuotaTaskLogOptions;

    private GetLogLevelsByResourceTypesResponse(BuilderImpl builder) {
        super(builder);
        this.defaultLogLevel = builder.defaultLogLevel;
        this.wirelessGatewayLogOptions = builder.wirelessGatewayLogOptions;
        this.wirelessDeviceLogOptions = builder.wirelessDeviceLogOptions;
        this.fuotaTaskLogOptions = builder.fuotaTaskLogOptions;
    }

    public final LogLevel defaultLogLevel() {
        return LogLevel.fromValue(this.defaultLogLevel);
    }

    public final String defaultLogLevelAsString() {
        return this.defaultLogLevel;
    }

    public final boolean hasWirelessGatewayLogOptions() {
        return this.wirelessGatewayLogOptions != null && !(this.wirelessGatewayLogOptions instanceof SdkAutoConstructList);
    }

    public final List<WirelessGatewayLogOption> wirelessGatewayLogOptions() {
        return this.wirelessGatewayLogOptions;
    }

    public final boolean hasWirelessDeviceLogOptions() {
        return this.wirelessDeviceLogOptions != null && !(this.wirelessDeviceLogOptions instanceof SdkAutoConstructList);
    }

    public final List<WirelessDeviceLogOption> wirelessDeviceLogOptions() {
        return this.wirelessDeviceLogOptions;
    }

    public final boolean hasFuotaTaskLogOptions() {
        return this.fuotaTaskLogOptions != null && !(this.fuotaTaskLogOptions instanceof SdkAutoConstructList);
    }

    public final List<FuotaTaskLogOption> fuotaTaskLogOptions() {
        return this.fuotaTaskLogOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWirelessGatewayLogOptions() ? this.wirelessGatewayLogOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWirelessDeviceLogOptions() ? this.wirelessDeviceLogOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFuotaTaskLogOptions() ? this.fuotaTaskLogOptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogLevelsByResourceTypesResponse)) {
            return false;
        }
        GetLogLevelsByResourceTypesResponse other = (GetLogLevelsByResourceTypesResponse)((Object)obj);
        return Objects.equals(this.defaultLogLevelAsString(), other.defaultLogLevelAsString()) && this.hasWirelessGatewayLogOptions() == other.hasWirelessGatewayLogOptions() && Objects.equals(this.wirelessGatewayLogOptions(), other.wirelessGatewayLogOptions()) && this.hasWirelessDeviceLogOptions() == other.hasWirelessDeviceLogOptions() && Objects.equals(this.wirelessDeviceLogOptions(), other.wirelessDeviceLogOptions()) && this.hasFuotaTaskLogOptions() == other.hasFuotaTaskLogOptions() && Objects.equals(this.fuotaTaskLogOptions(), other.fuotaTaskLogOptions());
    }

    public final String toString() {
        return ToString.builder((String)"GetLogLevelsByResourceTypesResponse").add("DefaultLogLevel", (Object)this.defaultLogLevelAsString()).add("WirelessGatewayLogOptions", this.hasWirelessGatewayLogOptions() ? this.wirelessGatewayLogOptions() : null).add("WirelessDeviceLogOptions", this.hasWirelessDeviceLogOptions() ? this.wirelessDeviceLogOptions() : null).add("FuotaTaskLogOptions", this.hasFuotaTaskLogOptions() ? this.fuotaTaskLogOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultLogLevel": {
                return Optional.ofNullable(clazz.cast(this.defaultLogLevelAsString()));
            }
            case "WirelessGatewayLogOptions": {
                return Optional.ofNullable(clazz.cast(this.wirelessGatewayLogOptions()));
            }
            case "WirelessDeviceLogOptions": {
                return Optional.ofNullable(clazz.cast(this.wirelessDeviceLogOptions()));
            }
            case "FuotaTaskLogOptions": {
                return Optional.ofNullable(clazz.cast(this.fuotaTaskLogOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DefaultLogLevel", DEFAULT_LOG_LEVEL_FIELD);
        map.put("WirelessGatewayLogOptions", WIRELESS_GATEWAY_LOG_OPTIONS_FIELD);
        map.put("WirelessDeviceLogOptions", WIRELESS_DEVICE_LOG_OPTIONS_FIELD);
        map.put("FuotaTaskLogOptions", FUOTA_TASK_LOG_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLogLevelsByResourceTypesResponse, T> g) {
        return obj -> g.apply((GetLogLevelsByResourceTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String defaultLogLevel;
        private List<WirelessGatewayLogOption> wirelessGatewayLogOptions = DefaultSdkAutoConstructList.getInstance();
        private List<WirelessDeviceLogOption> wirelessDeviceLogOptions = DefaultSdkAutoConstructList.getInstance();
        private List<FuotaTaskLogOption> fuotaTaskLogOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogLevelsByResourceTypesResponse model) {
            super(model);
            this.defaultLogLevel(model.defaultLogLevel);
            this.wirelessGatewayLogOptions(model.wirelessGatewayLogOptions);
            this.wirelessDeviceLogOptions(model.wirelessDeviceLogOptions);
            this.fuotaTaskLogOptions(model.fuotaTaskLogOptions);
        }

        public final String getDefaultLogLevel() {
            return this.defaultLogLevel;
        }

        public final void setDefaultLogLevel(String defaultLogLevel) {
            this.defaultLogLevel = defaultLogLevel;
        }

        @Override
        public final Builder defaultLogLevel(String defaultLogLevel) {
            this.defaultLogLevel = defaultLogLevel;
            return this;
        }

        @Override
        public final Builder defaultLogLevel(LogLevel defaultLogLevel) {
            this.defaultLogLevel(defaultLogLevel == null ? null : defaultLogLevel.toString());
            return this;
        }

        public final List<WirelessGatewayLogOption.Builder> getWirelessGatewayLogOptions() {
            List<WirelessGatewayLogOption.Builder> result = WirelessGatewayLogOptionListCopier.copyToBuilder(this.wirelessGatewayLogOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWirelessGatewayLogOptions(Collection<WirelessGatewayLogOption.BuilderImpl> wirelessGatewayLogOptions) {
            this.wirelessGatewayLogOptions = WirelessGatewayLogOptionListCopier.copyFromBuilder(wirelessGatewayLogOptions);
        }

        @Override
        public final Builder wirelessGatewayLogOptions(Collection<WirelessGatewayLogOption> wirelessGatewayLogOptions) {
            this.wirelessGatewayLogOptions = WirelessGatewayLogOptionListCopier.copy(wirelessGatewayLogOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessGatewayLogOptions(WirelessGatewayLogOption ... wirelessGatewayLogOptions) {
            this.wirelessGatewayLogOptions(Arrays.asList(wirelessGatewayLogOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessGatewayLogOptions(Consumer<WirelessGatewayLogOption.Builder> ... wirelessGatewayLogOptions) {
            this.wirelessGatewayLogOptions(Stream.of(wirelessGatewayLogOptions).map(c -> (WirelessGatewayLogOption)((WirelessGatewayLogOption.Builder)WirelessGatewayLogOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<WirelessDeviceLogOption.Builder> getWirelessDeviceLogOptions() {
            List<WirelessDeviceLogOption.Builder> result = WirelessDeviceLogOptionListCopier.copyToBuilder(this.wirelessDeviceLogOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWirelessDeviceLogOptions(Collection<WirelessDeviceLogOption.BuilderImpl> wirelessDeviceLogOptions) {
            this.wirelessDeviceLogOptions = WirelessDeviceLogOptionListCopier.copyFromBuilder(wirelessDeviceLogOptions);
        }

        @Override
        public final Builder wirelessDeviceLogOptions(Collection<WirelessDeviceLogOption> wirelessDeviceLogOptions) {
            this.wirelessDeviceLogOptions = WirelessDeviceLogOptionListCopier.copy(wirelessDeviceLogOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDeviceLogOptions(WirelessDeviceLogOption ... wirelessDeviceLogOptions) {
            this.wirelessDeviceLogOptions(Arrays.asList(wirelessDeviceLogOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDeviceLogOptions(Consumer<WirelessDeviceLogOption.Builder> ... wirelessDeviceLogOptions) {
            this.wirelessDeviceLogOptions(Stream.of(wirelessDeviceLogOptions).map(c -> (WirelessDeviceLogOption)((WirelessDeviceLogOption.Builder)WirelessDeviceLogOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FuotaTaskLogOption.Builder> getFuotaTaskLogOptions() {
            List<FuotaTaskLogOption.Builder> result = FuotaTaskLogOptionListCopier.copyToBuilder(this.fuotaTaskLogOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFuotaTaskLogOptions(Collection<FuotaTaskLogOption.BuilderImpl> fuotaTaskLogOptions) {
            this.fuotaTaskLogOptions = FuotaTaskLogOptionListCopier.copyFromBuilder(fuotaTaskLogOptions);
        }

        @Override
        public final Builder fuotaTaskLogOptions(Collection<FuotaTaskLogOption> fuotaTaskLogOptions) {
            this.fuotaTaskLogOptions = FuotaTaskLogOptionListCopier.copy(fuotaTaskLogOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fuotaTaskLogOptions(FuotaTaskLogOption ... fuotaTaskLogOptions) {
            this.fuotaTaskLogOptions(Arrays.asList(fuotaTaskLogOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fuotaTaskLogOptions(Consumer<FuotaTaskLogOption.Builder> ... fuotaTaskLogOptions) {
            this.fuotaTaskLogOptions(Stream.of(fuotaTaskLogOptions).map(c -> (FuotaTaskLogOption)((FuotaTaskLogOption.Builder)FuotaTaskLogOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetLogLevelsByResourceTypesResponse build() {
            return new GetLogLevelsByResourceTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLogLevelsByResourceTypesResponse> {
        public Builder defaultLogLevel(String var1);

        public Builder defaultLogLevel(LogLevel var1);

        public Builder wirelessGatewayLogOptions(Collection<WirelessGatewayLogOption> var1);

        public Builder wirelessGatewayLogOptions(WirelessGatewayLogOption ... var1);

        public Builder wirelessGatewayLogOptions(Consumer<WirelessGatewayLogOption.Builder> ... var1);

        public Builder wirelessDeviceLogOptions(Collection<WirelessDeviceLogOption> var1);

        public Builder wirelessDeviceLogOptions(WirelessDeviceLogOption ... var1);

        public Builder wirelessDeviceLogOptions(Consumer<WirelessDeviceLogOption.Builder> ... var1);

        public Builder fuotaTaskLogOptions(Collection<FuotaTaskLogOption> var1);

        public Builder fuotaTaskLogOptions(FuotaTaskLogOption ... var1);

        public Builder fuotaTaskLogOptions(Consumer<FuotaTaskLogOption.Builder> ... var1);
    }
}

