/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.EventNotificationTopicStatus;
import software.amazon.awssdk.services.iotwireless.model.SidewalkEventNotificationConfigurations;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageDeliveryStatusEventConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageDeliveryStatusEventConfiguration> {
    private static final SdkField<SidewalkEventNotificationConfigurations> SIDEWALK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sidewalk").getter(MessageDeliveryStatusEventConfiguration.getter(MessageDeliveryStatusEventConfiguration::sidewalk)).setter(MessageDeliveryStatusEventConfiguration.setter(Builder::sidewalk)).constructor(SidewalkEventNotificationConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()}).build();
    private static final SdkField<String> WIRELESS_DEVICE_ID_EVENT_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WirelessDeviceIdEventTopic").getter(MessageDeliveryStatusEventConfiguration.getter(MessageDeliveryStatusEventConfiguration::wirelessDeviceIdEventTopicAsString)).setter(MessageDeliveryStatusEventConfiguration.setter(Builder::wirelessDeviceIdEventTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDeviceIdEventTopic").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIDEWALK_FIELD, WIRELESS_DEVICE_ID_EVENT_TOPIC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MessageDeliveryStatusEventConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SidewalkEventNotificationConfigurations sidewalk;
    private final String wirelessDeviceIdEventTopic;

    private MessageDeliveryStatusEventConfiguration(BuilderImpl builder) {
        this.sidewalk = builder.sidewalk;
        this.wirelessDeviceIdEventTopic = builder.wirelessDeviceIdEventTopic;
    }

    public final SidewalkEventNotificationConfigurations sidewalk() {
        return this.sidewalk;
    }

    public final EventNotificationTopicStatus wirelessDeviceIdEventTopic() {
        return EventNotificationTopicStatus.fromValue(this.wirelessDeviceIdEventTopic);
    }

    public final String wirelessDeviceIdEventTopicAsString() {
        return this.wirelessDeviceIdEventTopic;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sidewalk());
        hashCode = 31 * hashCode + Objects.hashCode(this.wirelessDeviceIdEventTopicAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageDeliveryStatusEventConfiguration)) {
            return false;
        }
        MessageDeliveryStatusEventConfiguration other = (MessageDeliveryStatusEventConfiguration)obj;
        return Objects.equals(this.sidewalk(), other.sidewalk()) && Objects.equals(this.wirelessDeviceIdEventTopicAsString(), other.wirelessDeviceIdEventTopicAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MessageDeliveryStatusEventConfiguration").add("Sidewalk", (Object)this.sidewalk()).add("WirelessDeviceIdEventTopic", (Object)this.wirelessDeviceIdEventTopicAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sidewalk": {
                return Optional.ofNullable(clazz.cast(this.sidewalk()));
            }
            case "WirelessDeviceIdEventTopic": {
                return Optional.ofNullable(clazz.cast(this.wirelessDeviceIdEventTopicAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Sidewalk", SIDEWALK_FIELD);
        map.put("WirelessDeviceIdEventTopic", WIRELESS_DEVICE_ID_EVENT_TOPIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageDeliveryStatusEventConfiguration, T> g) {
        return obj -> g.apply((MessageDeliveryStatusEventConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SidewalkEventNotificationConfigurations sidewalk;
        private String wirelessDeviceIdEventTopic;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageDeliveryStatusEventConfiguration model) {
            this.sidewalk(model.sidewalk);
            this.wirelessDeviceIdEventTopic(model.wirelessDeviceIdEventTopic);
        }

        public final SidewalkEventNotificationConfigurations.Builder getSidewalk() {
            return this.sidewalk != null ? this.sidewalk.toBuilder() : null;
        }

        public final void setSidewalk(SidewalkEventNotificationConfigurations.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkEventNotificationConfigurations sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        public final String getWirelessDeviceIdEventTopic() {
            return this.wirelessDeviceIdEventTopic;
        }

        public final void setWirelessDeviceIdEventTopic(String wirelessDeviceIdEventTopic) {
            this.wirelessDeviceIdEventTopic = wirelessDeviceIdEventTopic;
        }

        @Override
        public final Builder wirelessDeviceIdEventTopic(String wirelessDeviceIdEventTopic) {
            this.wirelessDeviceIdEventTopic = wirelessDeviceIdEventTopic;
            return this;
        }

        @Override
        public final Builder wirelessDeviceIdEventTopic(EventNotificationTopicStatus wirelessDeviceIdEventTopic) {
            this.wirelessDeviceIdEventTopic(wirelessDeviceIdEventTopic == null ? null : wirelessDeviceIdEventTopic.toString());
            return this;
        }

        public MessageDeliveryStatusEventConfiguration build() {
            return new MessageDeliveryStatusEventConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageDeliveryStatusEventConfiguration> {
        public Builder sidewalk(SidewalkEventNotificationConfigurations var1);

        default public Builder sidewalk(Consumer<SidewalkEventNotificationConfigurations.Builder> sidewalk) {
            return this.sidewalk((SidewalkEventNotificationConfigurations)((SidewalkEventNotificationConfigurations.Builder)SidewalkEventNotificationConfigurations.builder().applyMutation(sidewalk)).build());
        }

        public Builder wirelessDeviceIdEventTopic(String var1);

        public Builder wirelessDeviceIdEventTopic(EventNotificationTopicStatus var1);
    }
}

