/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Accuracy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Accuracy> {
    private static final SdkField<Float> HORIZONTAL_ACCURACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("HorizontalAccuracy").getter(Accuracy.getter(Accuracy::horizontalAccuracy)).setter(Accuracy.setter(Builder::horizontalAccuracy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HorizontalAccuracy").build()}).build();
    private static final SdkField<Float> VERTICAL_ACCURACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("VerticalAccuracy").getter(Accuracy.getter(Accuracy::verticalAccuracy)).setter(Accuracy.setter(Builder::verticalAccuracy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerticalAccuracy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HORIZONTAL_ACCURACY_FIELD, VERTICAL_ACCURACY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Accuracy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Float horizontalAccuracy;
    private final Float verticalAccuracy;

    private Accuracy(BuilderImpl builder) {
        this.horizontalAccuracy = builder.horizontalAccuracy;
        this.verticalAccuracy = builder.verticalAccuracy;
    }

    public final Float horizontalAccuracy() {
        return this.horizontalAccuracy;
    }

    public final Float verticalAccuracy() {
        return this.verticalAccuracy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.horizontalAccuracy());
        hashCode = 31 * hashCode + Objects.hashCode(this.verticalAccuracy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Accuracy)) {
            return false;
        }
        Accuracy other = (Accuracy)obj;
        return Objects.equals(this.horizontalAccuracy(), other.horizontalAccuracy()) && Objects.equals(this.verticalAccuracy(), other.verticalAccuracy());
    }

    public final String toString() {
        return ToString.builder((String)"Accuracy").add("HorizontalAccuracy", (Object)this.horizontalAccuracy()).add("VerticalAccuracy", (Object)this.verticalAccuracy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HorizontalAccuracy": {
                return Optional.ofNullable(clazz.cast(this.horizontalAccuracy()));
            }
            case "VerticalAccuracy": {
                return Optional.ofNullable(clazz.cast(this.verticalAccuracy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Float>> map = new HashMap<String, SdkField<Float>>();
        map.put("HorizontalAccuracy", HORIZONTAL_ACCURACY_FIELD);
        map.put("VerticalAccuracy", VERTICAL_ACCURACY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Accuracy, T> g) {
        return obj -> g.apply((Accuracy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float horizontalAccuracy;
        private Float verticalAccuracy;

        private BuilderImpl() {
        }

        private BuilderImpl(Accuracy model) {
            this.horizontalAccuracy(model.horizontalAccuracy);
            this.verticalAccuracy(model.verticalAccuracy);
        }

        public final Float getHorizontalAccuracy() {
            return this.horizontalAccuracy;
        }

        public final void setHorizontalAccuracy(Float horizontalAccuracy) {
            this.horizontalAccuracy = horizontalAccuracy;
        }

        @Override
        public final Builder horizontalAccuracy(Float horizontalAccuracy) {
            this.horizontalAccuracy = horizontalAccuracy;
            return this;
        }

        public final Float getVerticalAccuracy() {
            return this.verticalAccuracy;
        }

        public final void setVerticalAccuracy(Float verticalAccuracy) {
            this.verticalAccuracy = verticalAccuracy;
        }

        @Override
        public final Builder verticalAccuracy(Float verticalAccuracy) {
            this.verticalAccuracy = verticalAccuracy;
            return this;
        }

        public Accuracy build() {
            return new Accuracy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Accuracy> {
        public Builder horizontalAccuracy(Float var1);

        public Builder verticalAccuracy(Float var1);
    }
}

