/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceImportTask;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceImportTaskListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWirelessDeviceImportTasksResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, ListWirelessDeviceImportTasksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWirelessDeviceImportTasksResponse.getter(ListWirelessDeviceImportTasksResponse::nextToken)).setter(ListWirelessDeviceImportTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<WirelessDeviceImportTask>> WIRELESS_DEVICE_IMPORT_TASK_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WirelessDeviceImportTaskList").getter(ListWirelessDeviceImportTasksResponse.getter(ListWirelessDeviceImportTasksResponse::wirelessDeviceImportTaskList)).setter(ListWirelessDeviceImportTasksResponse.setter(Builder::wirelessDeviceImportTaskList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDeviceImportTaskList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WirelessDeviceImportTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, WIRELESS_DEVICE_IMPORT_TASK_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWirelessDeviceImportTasksResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<WirelessDeviceImportTask> wirelessDeviceImportTaskList;

    private ListWirelessDeviceImportTasksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.wirelessDeviceImportTaskList = builder.wirelessDeviceImportTaskList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasWirelessDeviceImportTaskList() {
        return this.wirelessDeviceImportTaskList != null && !(this.wirelessDeviceImportTaskList instanceof SdkAutoConstructList);
    }

    public final List<WirelessDeviceImportTask> wirelessDeviceImportTaskList() {
        return this.wirelessDeviceImportTaskList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWirelessDeviceImportTaskList() ? this.wirelessDeviceImportTaskList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWirelessDeviceImportTasksResponse)) {
            return false;
        }
        ListWirelessDeviceImportTasksResponse other = (ListWirelessDeviceImportTasksResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasWirelessDeviceImportTaskList() == other.hasWirelessDeviceImportTaskList() && Objects.equals(this.wirelessDeviceImportTaskList(), other.wirelessDeviceImportTaskList());
    }

    public final String toString() {
        return ToString.builder((String)"ListWirelessDeviceImportTasksResponse").add("NextToken", (Object)this.nextToken()).add("WirelessDeviceImportTaskList", this.hasWirelessDeviceImportTaskList() ? this.wirelessDeviceImportTaskList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "WirelessDeviceImportTaskList": {
                return Optional.ofNullable(clazz.cast(this.wirelessDeviceImportTaskList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("WirelessDeviceImportTaskList", WIRELESS_DEVICE_IMPORT_TASK_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWirelessDeviceImportTasksResponse, T> g) {
        return obj -> g.apply((ListWirelessDeviceImportTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<WirelessDeviceImportTask> wirelessDeviceImportTaskList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWirelessDeviceImportTasksResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.wirelessDeviceImportTaskList(model.wirelessDeviceImportTaskList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WirelessDeviceImportTask.Builder> getWirelessDeviceImportTaskList() {
            List<WirelessDeviceImportTask.Builder> result = WirelessDeviceImportTaskListCopier.copyToBuilder(this.wirelessDeviceImportTaskList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWirelessDeviceImportTaskList(Collection<WirelessDeviceImportTask.BuilderImpl> wirelessDeviceImportTaskList) {
            this.wirelessDeviceImportTaskList = WirelessDeviceImportTaskListCopier.copyFromBuilder(wirelessDeviceImportTaskList);
        }

        @Override
        public final Builder wirelessDeviceImportTaskList(Collection<WirelessDeviceImportTask> wirelessDeviceImportTaskList) {
            this.wirelessDeviceImportTaskList = WirelessDeviceImportTaskListCopier.copy(wirelessDeviceImportTaskList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDeviceImportTaskList(WirelessDeviceImportTask ... wirelessDeviceImportTaskList) {
            this.wirelessDeviceImportTaskList(Arrays.asList(wirelessDeviceImportTaskList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDeviceImportTaskList(Consumer<WirelessDeviceImportTask.Builder> ... wirelessDeviceImportTaskList) {
            this.wirelessDeviceImportTaskList(Stream.of(wirelessDeviceImportTaskList).map(c -> (WirelessDeviceImportTask)((WirelessDeviceImportTask.Builder)WirelessDeviceImportTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWirelessDeviceImportTasksResponse build() {
            return new ListWirelessDeviceImportTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWirelessDeviceImportTasksResponse> {
        public Builder nextToken(String var1);

        public Builder wirelessDeviceImportTaskList(Collection<WirelessDeviceImportTask> var1);

        public Builder wirelessDeviceImportTaskList(WirelessDeviceImportTask ... var1);

        public Builder wirelessDeviceImportTaskList(Consumer<WirelessDeviceImportTask.Builder> ... var1);
    }
}

