/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IdentifierType {
    PARTNER_ACCOUNT_ID("PartnerAccountId"),
    DEV_EUI("DevEui"),
    FUOTA_TASK_ID("FuotaTaskId"),
    GATEWAY_EUI("GatewayEui"),
    WIRELESS_DEVICE_ID("WirelessDeviceId"),
    WIRELESS_GATEWAY_ID("WirelessGatewayId"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IdentifierType> VALUE_MAP;
    private final String value;

    private IdentifierType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IdentifierType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IdentifierType> knownValues() {
        EnumSet<IdentifierType> knownValues = EnumSet.allOf(IdentifierType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IdentifierType.class, IdentifierType::toString);
    }
}

