/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.LoRaWANFuotaTask;
import software.amazon.awssdk.services.iotwireless.model.Tag;
import software.amazon.awssdk.services.iotwireless.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFuotaTaskRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, CreateFuotaTaskRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateFuotaTaskRequest.getter(CreateFuotaTaskRequest::name)).setter(CreateFuotaTaskRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateFuotaTaskRequest.getter(CreateFuotaTaskRequest::description)).setter(CreateFuotaTaskRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateFuotaTaskRequest.getter(CreateFuotaTaskRequest::clientRequestToken)).setter(CreateFuotaTaskRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<LoRaWANFuotaTask> LO_RA_WAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoRaWAN").getter(CreateFuotaTaskRequest.getter(CreateFuotaTaskRequest::loRaWAN)).setter(CreateFuotaTaskRequest.setter(Builder::loRaWAN)).constructor(LoRaWANFuotaTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()}).build();
    private static final SdkField<String> FIRMWARE_UPDATE_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirmwareUpdateImage").getter(CreateFuotaTaskRequest.getter(CreateFuotaTaskRequest::firmwareUpdateImage)).setter(CreateFuotaTaskRequest.setter(Builder::firmwareUpdateImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirmwareUpdateImage").build()}).build();
    private static final SdkField<String> FIRMWARE_UPDATE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirmwareUpdateRole").getter(CreateFuotaTaskRequest.getter(CreateFuotaTaskRequest::firmwareUpdateRole)).setter(CreateFuotaTaskRequest.setter(Builder::firmwareUpdateRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirmwareUpdateRole").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateFuotaTaskRequest.getter(CreateFuotaTaskRequest::tags)).setter(CreateFuotaTaskRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> REDUNDANCY_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RedundancyPercent").getter(CreateFuotaTaskRequest.getter(CreateFuotaTaskRequest::redundancyPercent)).setter(CreateFuotaTaskRequest.setter(Builder::redundancyPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedundancyPercent").build()}).build();
    private static final SdkField<Integer> FRAGMENT_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FragmentSizeBytes").getter(CreateFuotaTaskRequest.getter(CreateFuotaTaskRequest::fragmentSizeBytes)).setter(CreateFuotaTaskRequest.setter(Builder::fragmentSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentSizeBytes").build()}).build();
    private static final SdkField<Integer> FRAGMENT_INTERVAL_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FragmentIntervalMS").getter(CreateFuotaTaskRequest.getter(CreateFuotaTaskRequest::fragmentIntervalMS)).setter(CreateFuotaTaskRequest.setter(Builder::fragmentIntervalMS)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentIntervalMS").build()}).build();
    private static final SdkField<String> DESCRIPTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Descriptor").getter(CreateFuotaTaskRequest.getter(CreateFuotaTaskRequest::descriptor)).setter(CreateFuotaTaskRequest.setter(Builder::descriptor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Descriptor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, CLIENT_REQUEST_TOKEN_FIELD, LO_RA_WAN_FIELD, FIRMWARE_UPDATE_IMAGE_FIELD, FIRMWARE_UPDATE_ROLE_FIELD, TAGS_FIELD, REDUNDANCY_PERCENT_FIELD, FRAGMENT_SIZE_BYTES_FIELD, FRAGMENT_INTERVAL_MS_FIELD, DESCRIPTOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateFuotaTaskRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String clientRequestToken;
    private final LoRaWANFuotaTask loRaWAN;
    private final String firmwareUpdateImage;
    private final String firmwareUpdateRole;
    private final List<Tag> tags;
    private final Integer redundancyPercent;
    private final Integer fragmentSizeBytes;
    private final Integer fragmentIntervalMS;
    private final String descriptor;

    private CreateFuotaTaskRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.clientRequestToken = builder.clientRequestToken;
        this.loRaWAN = builder.loRaWAN;
        this.firmwareUpdateImage = builder.firmwareUpdateImage;
        this.firmwareUpdateRole = builder.firmwareUpdateRole;
        this.tags = builder.tags;
        this.redundancyPercent = builder.redundancyPercent;
        this.fragmentSizeBytes = builder.fragmentSizeBytes;
        this.fragmentIntervalMS = builder.fragmentIntervalMS;
        this.descriptor = builder.descriptor;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final LoRaWANFuotaTask loRaWAN() {
        return this.loRaWAN;
    }

    public final String firmwareUpdateImage() {
        return this.firmwareUpdateImage;
    }

    public final String firmwareUpdateRole() {
        return this.firmwareUpdateRole;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Integer redundancyPercent() {
        return this.redundancyPercent;
    }

    public final Integer fragmentSizeBytes() {
        return this.fragmentSizeBytes;
    }

    public final Integer fragmentIntervalMS() {
        return this.fragmentIntervalMS;
    }

    public final String descriptor() {
        return this.descriptor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(this.firmwareUpdateImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.firmwareUpdateRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.redundancyPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentIntervalMS());
        hashCode = 31 * hashCode + Objects.hashCode(this.descriptor());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFuotaTaskRequest)) {
            return false;
        }
        CreateFuotaTaskRequest other = (CreateFuotaTaskRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.loRaWAN(), other.loRaWAN()) && Objects.equals(this.firmwareUpdateImage(), other.firmwareUpdateImage()) && Objects.equals(this.firmwareUpdateRole(), other.firmwareUpdateRole()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.redundancyPercent(), other.redundancyPercent()) && Objects.equals(this.fragmentSizeBytes(), other.fragmentSizeBytes()) && Objects.equals(this.fragmentIntervalMS(), other.fragmentIntervalMS()) && Objects.equals(this.descriptor(), other.descriptor());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFuotaTaskRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("LoRaWAN", (Object)this.loRaWAN()).add("FirmwareUpdateImage", (Object)this.firmwareUpdateImage()).add("FirmwareUpdateRole", (Object)this.firmwareUpdateRole()).add("Tags", this.hasTags() ? this.tags() : null).add("RedundancyPercent", (Object)this.redundancyPercent()).add("FragmentSizeBytes", (Object)this.fragmentSizeBytes()).add("FragmentIntervalMS", (Object)this.fragmentIntervalMS()).add("Descriptor", (Object)this.descriptor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "LoRaWAN": {
                return Optional.ofNullable(clazz.cast(this.loRaWAN()));
            }
            case "FirmwareUpdateImage": {
                return Optional.ofNullable(clazz.cast(this.firmwareUpdateImage()));
            }
            case "FirmwareUpdateRole": {
                return Optional.ofNullable(clazz.cast(this.firmwareUpdateRole()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "RedundancyPercent": {
                return Optional.ofNullable(clazz.cast(this.redundancyPercent()));
            }
            case "FragmentSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.fragmentSizeBytes()));
            }
            case "FragmentIntervalMS": {
                return Optional.ofNullable(clazz.cast(this.fragmentIntervalMS()));
            }
            case "Descriptor": {
                return Optional.ofNullable(clazz.cast(this.descriptor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("LoRaWAN", LO_RA_WAN_FIELD);
        map.put("FirmwareUpdateImage", FIRMWARE_UPDATE_IMAGE_FIELD);
        map.put("FirmwareUpdateRole", FIRMWARE_UPDATE_ROLE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("RedundancyPercent", REDUNDANCY_PERCENT_FIELD);
        map.put("FragmentSizeBytes", FRAGMENT_SIZE_BYTES_FIELD);
        map.put("FragmentIntervalMS", FRAGMENT_INTERVAL_MS_FIELD);
        map.put("Descriptor", DESCRIPTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFuotaTaskRequest, T> g) {
        return obj -> g.apply((CreateFuotaTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String clientRequestToken;
        private LoRaWANFuotaTask loRaWAN;
        private String firmwareUpdateImage;
        private String firmwareUpdateRole;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Integer redundancyPercent;
        private Integer fragmentSizeBytes;
        private Integer fragmentIntervalMS;
        private String descriptor;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFuotaTaskRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.clientRequestToken(model.clientRequestToken);
            this.loRaWAN(model.loRaWAN);
            this.firmwareUpdateImage(model.firmwareUpdateImage);
            this.firmwareUpdateRole(model.firmwareUpdateRole);
            this.tags(model.tags);
            this.redundancyPercent(model.redundancyPercent);
            this.fragmentSizeBytes(model.fragmentSizeBytes);
            this.fragmentIntervalMS(model.fragmentIntervalMS);
            this.descriptor(model.descriptor);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final LoRaWANFuotaTask.Builder getLoRaWAN() {
            return this.loRaWAN != null ? this.loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANFuotaTask.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANFuotaTask loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final String getFirmwareUpdateImage() {
            return this.firmwareUpdateImage;
        }

        public final void setFirmwareUpdateImage(String firmwareUpdateImage) {
            this.firmwareUpdateImage = firmwareUpdateImage;
        }

        @Override
        public final Builder firmwareUpdateImage(String firmwareUpdateImage) {
            this.firmwareUpdateImage = firmwareUpdateImage;
            return this;
        }

        public final String getFirmwareUpdateRole() {
            return this.firmwareUpdateRole;
        }

        public final void setFirmwareUpdateRole(String firmwareUpdateRole) {
            this.firmwareUpdateRole = firmwareUpdateRole;
        }

        @Override
        public final Builder firmwareUpdateRole(String firmwareUpdateRole) {
            this.firmwareUpdateRole = firmwareUpdateRole;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getRedundancyPercent() {
            return this.redundancyPercent;
        }

        public final void setRedundancyPercent(Integer redundancyPercent) {
            this.redundancyPercent = redundancyPercent;
        }

        @Override
        public final Builder redundancyPercent(Integer redundancyPercent) {
            this.redundancyPercent = redundancyPercent;
            return this;
        }

        public final Integer getFragmentSizeBytes() {
            return this.fragmentSizeBytes;
        }

        public final void setFragmentSizeBytes(Integer fragmentSizeBytes) {
            this.fragmentSizeBytes = fragmentSizeBytes;
        }

        @Override
        public final Builder fragmentSizeBytes(Integer fragmentSizeBytes) {
            this.fragmentSizeBytes = fragmentSizeBytes;
            return this;
        }

        public final Integer getFragmentIntervalMS() {
            return this.fragmentIntervalMS;
        }

        public final void setFragmentIntervalMS(Integer fragmentIntervalMS) {
            this.fragmentIntervalMS = fragmentIntervalMS;
        }

        @Override
        public final Builder fragmentIntervalMS(Integer fragmentIntervalMS) {
            this.fragmentIntervalMS = fragmentIntervalMS;
            return this;
        }

        public final String getDescriptor() {
            return this.descriptor;
        }

        public final void setDescriptor(String descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public final Builder descriptor(String descriptor) {
            this.descriptor = descriptor;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFuotaTaskRequest build() {
            return new CreateFuotaTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFuotaTaskRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder clientRequestToken(String var1);

        public Builder loRaWAN(LoRaWANFuotaTask var1);

        default public Builder loRaWAN(Consumer<LoRaWANFuotaTask.Builder> loRaWAN) {
            return this.loRaWAN((LoRaWANFuotaTask)((LoRaWANFuotaTask.Builder)LoRaWANFuotaTask.builder().applyMutation(loRaWAN)).build());
        }

        public Builder firmwareUpdateImage(String var1);

        public Builder firmwareUpdateRole(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder redundancyPercent(Integer var1);

        public Builder fragmentSizeBytes(Integer var1);

        public Builder fragmentIntervalMS(Integer var1);

        public Builder descriptor(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

