/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DakCertificateMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DakCertificateMetadata> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateId").getter(DakCertificateMetadata.getter(DakCertificateMetadata::certificateId)).setter(DakCertificateMetadata.setter(Builder::certificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateId").build()}).build();
    private static final SdkField<Integer> MAX_ALLOWED_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAllowedSignature").getter(DakCertificateMetadata.getter(DakCertificateMetadata::maxAllowedSignature)).setter(DakCertificateMetadata.setter(Builder::maxAllowedSignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllowedSignature").build()}).build();
    private static final SdkField<Boolean> FACTORY_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FactorySupport").getter(DakCertificateMetadata.getter(DakCertificateMetadata::factorySupport)).setter(DakCertificateMetadata.setter(Builder::factorySupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FactorySupport").build()}).build();
    private static final SdkField<String> AP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApId").getter(DakCertificateMetadata.getter(DakCertificateMetadata::apId)).setter(DakCertificateMetadata.setter(Builder::apId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApId").build()}).build();
    private static final SdkField<String> DEVICE_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceTypeId").getter(DakCertificateMetadata.getter(DakCertificateMetadata::deviceTypeId)).setter(DakCertificateMetadata.setter(Builder::deviceTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD, MAX_ALLOWED_SIGNATURE_FIELD, FACTORY_SUPPORT_FIELD, AP_ID_FIELD, DEVICE_TYPE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CertificateId", CERTIFICATE_ID_FIELD);
            this.put("MaxAllowedSignature", MAX_ALLOWED_SIGNATURE_FIELD);
            this.put("FactorySupport", FACTORY_SUPPORT_FIELD);
            this.put("ApId", AP_ID_FIELD);
            this.put("DeviceTypeId", DEVICE_TYPE_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String certificateId;
    private final Integer maxAllowedSignature;
    private final Boolean factorySupport;
    private final String apId;
    private final String deviceTypeId;

    private DakCertificateMetadata(BuilderImpl builder) {
        this.certificateId = builder.certificateId;
        this.maxAllowedSignature = builder.maxAllowedSignature;
        this.factorySupport = builder.factorySupport;
        this.apId = builder.apId;
        this.deviceTypeId = builder.deviceTypeId;
    }

    public final String certificateId() {
        return this.certificateId;
    }

    public final Integer maxAllowedSignature() {
        return this.maxAllowedSignature;
    }

    public final Boolean factorySupport() {
        return this.factorySupport;
    }

    public final String apId() {
        return this.apId;
    }

    public final String deviceTypeId() {
        return this.deviceTypeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAllowedSignature());
        hashCode = 31 * hashCode + Objects.hashCode(this.factorySupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.apId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceTypeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DakCertificateMetadata)) {
            return false;
        }
        DakCertificateMetadata other = (DakCertificateMetadata)obj;
        return Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.maxAllowedSignature(), other.maxAllowedSignature()) && Objects.equals(this.factorySupport(), other.factorySupport()) && Objects.equals(this.apId(), other.apId()) && Objects.equals(this.deviceTypeId(), other.deviceTypeId());
    }

    public final String toString() {
        return ToString.builder((String)"DakCertificateMetadata").add("CertificateId", (Object)this.certificateId()).add("MaxAllowedSignature", (Object)this.maxAllowedSignature()).add("FactorySupport", (Object)this.factorySupport()).add("ApId", (Object)this.apId()).add("DeviceTypeId", (Object)this.deviceTypeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "MaxAllowedSignature": {
                return Optional.ofNullable(clazz.cast(this.maxAllowedSignature()));
            }
            case "FactorySupport": {
                return Optional.ofNullable(clazz.cast(this.factorySupport()));
            }
            case "ApId": {
                return Optional.ofNullable(clazz.cast(this.apId()));
            }
            case "DeviceTypeId": {
                return Optional.ofNullable(clazz.cast(this.deviceTypeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DakCertificateMetadata, T> g) {
        return obj -> g.apply((DakCertificateMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateId;
        private Integer maxAllowedSignature;
        private Boolean factorySupport;
        private String apId;
        private String deviceTypeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DakCertificateMetadata model) {
            this.certificateId(model.certificateId);
            this.maxAllowedSignature(model.maxAllowedSignature);
            this.factorySupport(model.factorySupport);
            this.apId(model.apId);
            this.deviceTypeId(model.deviceTypeId);
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final Integer getMaxAllowedSignature() {
            return this.maxAllowedSignature;
        }

        public final void setMaxAllowedSignature(Integer maxAllowedSignature) {
            this.maxAllowedSignature = maxAllowedSignature;
        }

        @Override
        public final Builder maxAllowedSignature(Integer maxAllowedSignature) {
            this.maxAllowedSignature = maxAllowedSignature;
            return this;
        }

        public final Boolean getFactorySupport() {
            return this.factorySupport;
        }

        public final void setFactorySupport(Boolean factorySupport) {
            this.factorySupport = factorySupport;
        }

        @Override
        public final Builder factorySupport(Boolean factorySupport) {
            this.factorySupport = factorySupport;
            return this;
        }

        public final String getApId() {
            return this.apId;
        }

        public final void setApId(String apId) {
            this.apId = apId;
        }

        @Override
        public final Builder apId(String apId) {
            this.apId = apId;
            return this;
        }

        public final String getDeviceTypeId() {
            return this.deviceTypeId;
        }

        public final void setDeviceTypeId(String deviceTypeId) {
            this.deviceTypeId = deviceTypeId;
        }

        @Override
        public final Builder deviceTypeId(String deviceTypeId) {
            this.deviceTypeId = deviceTypeId;
            return this;
        }

        public DakCertificateMetadata build() {
            return new DakCertificateMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DakCertificateMetadata> {
        public Builder certificateId(String var1);

        public Builder maxAllowedSignature(Integer var1);

        public Builder factorySupport(Boolean var1);

        public Builder apId(String var1);

        public Builder deviceTypeId(String var1);
    }
}

