/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.SigningAlg;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CertificateList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CertificateList> {
    private static final SdkField<String> SIGNING_ALG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningAlg").getter(CertificateList.getter(CertificateList::signingAlgAsString)).setter(CertificateList.setter(Builder::signingAlg)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlg").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(CertificateList.getter(CertificateList::value)).setter(CertificateList.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNING_ALG_FIELD, VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String signingAlg;
    private final String value;

    private CertificateList(BuilderImpl builder) {
        this.signingAlg = builder.signingAlg;
        this.value = builder.value;
    }

    public final SigningAlg signingAlg() {
        return SigningAlg.fromValue(this.signingAlg);
    }

    public final String signingAlgAsString() {
        return this.signingAlg;
    }

    public final String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.signingAlgAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateList)) {
            return false;
        }
        CertificateList other = (CertificateList)obj;
        return Objects.equals(this.signingAlgAsString(), other.signingAlgAsString()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"CertificateList").add("SigningAlg", (Object)this.signingAlgAsString()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SigningAlg": {
                return Optional.ofNullable(clazz.cast(this.signingAlgAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CertificateList, T> g) {
        return obj -> g.apply((CertificateList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String signingAlg;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateList model) {
            this.signingAlg(model.signingAlg);
            this.value(model.value);
        }

        public final String getSigningAlg() {
            return this.signingAlg;
        }

        public final void setSigningAlg(String signingAlg) {
            this.signingAlg = signingAlg;
        }

        @Override
        public final Builder signingAlg(String signingAlg) {
            this.signingAlg = signingAlg;
            return this;
        }

        @Override
        public final Builder signingAlg(SigningAlg signingAlg) {
            this.signingAlg(signingAlg == null ? null : signingAlg.toString());
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public CertificateList build() {
            return new CertificateList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CertificateList> {
        public Builder signingAlg(String var1);

        public Builder signingAlg(SigningAlg var1);

        public Builder value(String var1);
    }
}

