/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.EventNotificationPartnerType;
import software.amazon.awssdk.services.iotwireless.model.IdentifierType;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceEventConfigurationRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, GetResourceEventConfigurationRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(GetResourceEventConfigurationRequest.getter(GetResourceEventConfigurationRequest::identifier)).setter(GetResourceEventConfigurationRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()}).build();
    private static final SdkField<String> IDENTIFIER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentifierType").getter(GetResourceEventConfigurationRequest.getter(GetResourceEventConfigurationRequest::identifierTypeAsString)).setter(GetResourceEventConfigurationRequest.setter(Builder::identifierType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("identifierType").build()}).build();
    private static final SdkField<String> PARTNER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartnerType").getter(GetResourceEventConfigurationRequest.getter(GetResourceEventConfigurationRequest::partnerTypeAsString)).setter(GetResourceEventConfigurationRequest.setter(Builder::partnerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("partnerType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, IDENTIFIER_TYPE_FIELD, PARTNER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetResourceEventConfigurationRequest.memberNameToFieldInitializer();
    private final String identifier;
    private final String identifierType;
    private final String partnerType;

    private GetResourceEventConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.identifierType = builder.identifierType;
        this.partnerType = builder.partnerType;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final IdentifierType identifierType() {
        return IdentifierType.fromValue(this.identifierType);
    }

    public final String identifierTypeAsString() {
        return this.identifierType;
    }

    public final EventNotificationPartnerType partnerType() {
        return EventNotificationPartnerType.fromValue(this.partnerType);
    }

    public final String partnerTypeAsString() {
        return this.partnerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifierTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceEventConfigurationRequest)) {
            return false;
        }
        GetResourceEventConfigurationRequest other = (GetResourceEventConfigurationRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.identifierTypeAsString(), other.identifierTypeAsString()) && Objects.equals(this.partnerTypeAsString(), other.partnerTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceEventConfigurationRequest").add("Identifier", (Object)this.identifier()).add("IdentifierType", (Object)this.identifierTypeAsString()).add("PartnerType", (Object)this.partnerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "IdentifierType": {
                return Optional.ofNullable(clazz.cast(this.identifierTypeAsString()));
            }
            case "PartnerType": {
                return Optional.ofNullable(clazz.cast(this.partnerTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("identifierType", IDENTIFIER_TYPE_FIELD);
        map.put("partnerType", PARTNER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceEventConfigurationRequest, T> g) {
        return obj -> g.apply((GetResourceEventConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private String identifierType;
        private String partnerType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceEventConfigurationRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.identifierType(model.identifierType);
            this.partnerType(model.partnerType);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getIdentifierType() {
            return this.identifierType;
        }

        public final void setIdentifierType(String identifierType) {
            this.identifierType = identifierType;
        }

        @Override
        public final Builder identifierType(String identifierType) {
            this.identifierType = identifierType;
            return this;
        }

        @Override
        public final Builder identifierType(IdentifierType identifierType) {
            this.identifierType(identifierType == null ? null : identifierType.toString());
            return this;
        }

        public final String getPartnerType() {
            return this.partnerType;
        }

        public final void setPartnerType(String partnerType) {
            this.partnerType = partnerType;
        }

        @Override
        public final Builder partnerType(String partnerType) {
            this.partnerType = partnerType;
            return this;
        }

        @Override
        public final Builder partnerType(EventNotificationPartnerType partnerType) {
            this.partnerType(partnerType == null ? null : partnerType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceEventConfigurationRequest build() {
            return new GetResourceEventConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceEventConfigurationRequest> {
        public Builder identifier(String var1);

        public Builder identifierType(String var1);

        public Builder identifierType(IdentifierType var1);

        public Builder partnerType(String var1);

        public Builder partnerType(EventNotificationPartnerType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

