/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.DlClass;
import software.amazon.awssdk.services.iotwireless.model.ParticipatingGatewaysMulticast;
import software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoRaWANMulticastGet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoRaWANMulticastGet> {
    private static final SdkField<String> RF_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RfRegion").getter(LoRaWANMulticastGet.getter(LoRaWANMulticastGet::rfRegionAsString)).setter(LoRaWANMulticastGet.setter(Builder::rfRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RfRegion").build()}).build();
    private static final SdkField<String> DL_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DlClass").getter(LoRaWANMulticastGet.getter(LoRaWANMulticastGet::dlClassAsString)).setter(LoRaWANMulticastGet.setter(Builder::dlClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DlClass").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_DEVICES_REQUESTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfDevicesRequested").getter(LoRaWANMulticastGet.getter(LoRaWANMulticastGet::numberOfDevicesRequested)).setter(LoRaWANMulticastGet.setter(Builder::numberOfDevicesRequested)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDevicesRequested").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_DEVICES_IN_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfDevicesInGroup").getter(LoRaWANMulticastGet.getter(LoRaWANMulticastGet::numberOfDevicesInGroup)).setter(LoRaWANMulticastGet.setter(Builder::numberOfDevicesInGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDevicesInGroup").build()}).build();
    private static final SdkField<ParticipatingGatewaysMulticast> PARTICIPATING_GATEWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParticipatingGateways").getter(LoRaWANMulticastGet.getter(LoRaWANMulticastGet::participatingGateways)).setter(LoRaWANMulticastGet.setter(Builder::participatingGateways)).constructor(ParticipatingGatewaysMulticast::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipatingGateways").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RF_REGION_FIELD, DL_CLASS_FIELD, NUMBER_OF_DEVICES_REQUESTED_FIELD, NUMBER_OF_DEVICES_IN_GROUP_FIELD, PARTICIPATING_GATEWAYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RfRegion", RF_REGION_FIELD);
            this.put("DlClass", DL_CLASS_FIELD);
            this.put("NumberOfDevicesRequested", NUMBER_OF_DEVICES_REQUESTED_FIELD);
            this.put("NumberOfDevicesInGroup", NUMBER_OF_DEVICES_IN_GROUP_FIELD);
            this.put("ParticipatingGateways", PARTICIPATING_GATEWAYS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String rfRegion;
    private final String dlClass;
    private final Integer numberOfDevicesRequested;
    private final Integer numberOfDevicesInGroup;
    private final ParticipatingGatewaysMulticast participatingGateways;

    private LoRaWANMulticastGet(BuilderImpl builder) {
        this.rfRegion = builder.rfRegion;
        this.dlClass = builder.dlClass;
        this.numberOfDevicesRequested = builder.numberOfDevicesRequested;
        this.numberOfDevicesInGroup = builder.numberOfDevicesInGroup;
        this.participatingGateways = builder.participatingGateways;
    }

    public final SupportedRfRegion rfRegion() {
        return SupportedRfRegion.fromValue(this.rfRegion);
    }

    public final String rfRegionAsString() {
        return this.rfRegion;
    }

    public final DlClass dlClass() {
        return DlClass.fromValue(this.dlClass);
    }

    public final String dlClassAsString() {
        return this.dlClass;
    }

    public final Integer numberOfDevicesRequested() {
        return this.numberOfDevicesRequested;
    }

    public final Integer numberOfDevicesInGroup() {
        return this.numberOfDevicesInGroup;
    }

    public final ParticipatingGatewaysMulticast participatingGateways() {
        return this.participatingGateways;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rfRegionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dlClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDevicesRequested());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDevicesInGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.participatingGateways());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANMulticastGet)) {
            return false;
        }
        LoRaWANMulticastGet other = (LoRaWANMulticastGet)obj;
        return Objects.equals(this.rfRegionAsString(), other.rfRegionAsString()) && Objects.equals(this.dlClassAsString(), other.dlClassAsString()) && Objects.equals(this.numberOfDevicesRequested(), other.numberOfDevicesRequested()) && Objects.equals(this.numberOfDevicesInGroup(), other.numberOfDevicesInGroup()) && Objects.equals(this.participatingGateways(), other.participatingGateways());
    }

    public final String toString() {
        return ToString.builder((String)"LoRaWANMulticastGet").add("RfRegion", (Object)this.rfRegionAsString()).add("DlClass", (Object)this.dlClassAsString()).add("NumberOfDevicesRequested", (Object)this.numberOfDevicesRequested()).add("NumberOfDevicesInGroup", (Object)this.numberOfDevicesInGroup()).add("ParticipatingGateways", (Object)this.participatingGateways()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RfRegion": {
                return Optional.ofNullable(clazz.cast(this.rfRegionAsString()));
            }
            case "DlClass": {
                return Optional.ofNullable(clazz.cast(this.dlClassAsString()));
            }
            case "NumberOfDevicesRequested": {
                return Optional.ofNullable(clazz.cast(this.numberOfDevicesRequested()));
            }
            case "NumberOfDevicesInGroup": {
                return Optional.ofNullable(clazz.cast(this.numberOfDevicesInGroup()));
            }
            case "ParticipatingGateways": {
                return Optional.ofNullable(clazz.cast(this.participatingGateways()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANMulticastGet, T> g) {
        return obj -> g.apply((LoRaWANMulticastGet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String rfRegion;
        private String dlClass;
        private Integer numberOfDevicesRequested;
        private Integer numberOfDevicesInGroup;
        private ParticipatingGatewaysMulticast participatingGateways;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANMulticastGet model) {
            this.rfRegion(model.rfRegion);
            this.dlClass(model.dlClass);
            this.numberOfDevicesRequested(model.numberOfDevicesRequested);
            this.numberOfDevicesInGroup(model.numberOfDevicesInGroup);
            this.participatingGateways(model.participatingGateways);
        }

        public final String getRfRegion() {
            return this.rfRegion;
        }

        public final void setRfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
        }

        @Override
        public final Builder rfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
            return this;
        }

        @Override
        public final Builder rfRegion(SupportedRfRegion rfRegion) {
            this.rfRegion(rfRegion == null ? null : rfRegion.toString());
            return this;
        }

        public final String getDlClass() {
            return this.dlClass;
        }

        public final void setDlClass(String dlClass) {
            this.dlClass = dlClass;
        }

        @Override
        public final Builder dlClass(String dlClass) {
            this.dlClass = dlClass;
            return this;
        }

        @Override
        public final Builder dlClass(DlClass dlClass) {
            this.dlClass(dlClass == null ? null : dlClass.toString());
            return this;
        }

        public final Integer getNumberOfDevicesRequested() {
            return this.numberOfDevicesRequested;
        }

        public final void setNumberOfDevicesRequested(Integer numberOfDevicesRequested) {
            this.numberOfDevicesRequested = numberOfDevicesRequested;
        }

        @Override
        public final Builder numberOfDevicesRequested(Integer numberOfDevicesRequested) {
            this.numberOfDevicesRequested = numberOfDevicesRequested;
            return this;
        }

        public final Integer getNumberOfDevicesInGroup() {
            return this.numberOfDevicesInGroup;
        }

        public final void setNumberOfDevicesInGroup(Integer numberOfDevicesInGroup) {
            this.numberOfDevicesInGroup = numberOfDevicesInGroup;
        }

        @Override
        public final Builder numberOfDevicesInGroup(Integer numberOfDevicesInGroup) {
            this.numberOfDevicesInGroup = numberOfDevicesInGroup;
            return this;
        }

        public final ParticipatingGatewaysMulticast.Builder getParticipatingGateways() {
            return this.participatingGateways != null ? this.participatingGateways.toBuilder() : null;
        }

        public final void setParticipatingGateways(ParticipatingGatewaysMulticast.BuilderImpl participatingGateways) {
            this.participatingGateways = participatingGateways != null ? participatingGateways.build() : null;
        }

        @Override
        public final Builder participatingGateways(ParticipatingGatewaysMulticast participatingGateways) {
            this.participatingGateways = participatingGateways;
            return this;
        }

        public LoRaWANMulticastGet build() {
            return new LoRaWANMulticastGet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoRaWANMulticastGet> {
        public Builder rfRegion(String var1);

        public Builder rfRegion(SupportedRfRegion var1);

        public Builder dlClass(String var1);

        public Builder dlClass(DlClass var1);

        public Builder numberOfDevicesRequested(Integer var1);

        public Builder numberOfDevicesInGroup(Integer var1);

        public Builder participatingGateways(ParticipatingGatewaysMulticast var1);

        default public Builder participatingGateways(Consumer<ParticipatingGatewaysMulticast.Builder> participatingGateways) {
            return this.participatingGateways((ParticipatingGatewaysMulticast)((ParticipatingGatewaysMulticast.Builder)ParticipatingGatewaysMulticast.builder().applyMutation(participatingGateways)).build());
        }
    }
}

