/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.EventNotificationItemConfigurations;
import software.amazon.awssdk.services.iotwireless.model.EventNotificationPartnerType;
import software.amazon.awssdk.services.iotwireless.model.IdentifierType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventConfigurationItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventConfigurationItem> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(EventConfigurationItem.getter(EventConfigurationItem::identifier)).setter(EventConfigurationItem.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<String> IDENTIFIER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentifierType").getter(EventConfigurationItem.getter(EventConfigurationItem::identifierTypeAsString)).setter(EventConfigurationItem.setter(Builder::identifierType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifierType").build()}).build();
    private static final SdkField<String> PARTNER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartnerType").getter(EventConfigurationItem.getter(EventConfigurationItem::partnerTypeAsString)).setter(EventConfigurationItem.setter(Builder::partnerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerType").build()}).build();
    private static final SdkField<EventNotificationItemConfigurations> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Events").getter(EventConfigurationItem.getter(EventConfigurationItem::events)).setter(EventConfigurationItem.setter(Builder::events)).constructor(EventNotificationItemConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, IDENTIFIER_TYPE_FIELD, PARTNER_TYPE_FIELD, EVENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Identifier", IDENTIFIER_FIELD);
            this.put("IdentifierType", IDENTIFIER_TYPE_FIELD);
            this.put("PartnerType", PARTNER_TYPE_FIELD);
            this.put("Events", EVENTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String identifier;
    private final String identifierType;
    private final String partnerType;
    private final EventNotificationItemConfigurations events;

    private EventConfigurationItem(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.identifierType = builder.identifierType;
        this.partnerType = builder.partnerType;
        this.events = builder.events;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final IdentifierType identifierType() {
        return IdentifierType.fromValue(this.identifierType);
    }

    public final String identifierTypeAsString() {
        return this.identifierType;
    }

    public final EventNotificationPartnerType partnerType() {
        return EventNotificationPartnerType.fromValue(this.partnerType);
    }

    public final String partnerTypeAsString() {
        return this.partnerType;
    }

    public final EventNotificationItemConfigurations events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifierTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventConfigurationItem)) {
            return false;
        }
        EventConfigurationItem other = (EventConfigurationItem)obj;
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.identifierTypeAsString(), other.identifierTypeAsString()) && Objects.equals(this.partnerTypeAsString(), other.partnerTypeAsString()) && Objects.equals(this.events(), other.events());
    }

    public final String toString() {
        return ToString.builder((String)"EventConfigurationItem").add("Identifier", (Object)this.identifier()).add("IdentifierType", (Object)this.identifierTypeAsString()).add("PartnerType", (Object)this.partnerTypeAsString()).add("Events", (Object)this.events()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "IdentifierType": {
                return Optional.ofNullable(clazz.cast(this.identifierTypeAsString()));
            }
            case "PartnerType": {
                return Optional.ofNullable(clazz.cast(this.partnerTypeAsString()));
            }
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EventConfigurationItem, T> g) {
        return obj -> g.apply((EventConfigurationItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identifier;
        private String identifierType;
        private String partnerType;
        private EventNotificationItemConfigurations events;

        private BuilderImpl() {
        }

        private BuilderImpl(EventConfigurationItem model) {
            this.identifier(model.identifier);
            this.identifierType(model.identifierType);
            this.partnerType(model.partnerType);
            this.events(model.events);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getIdentifierType() {
            return this.identifierType;
        }

        public final void setIdentifierType(String identifierType) {
            this.identifierType = identifierType;
        }

        @Override
        public final Builder identifierType(String identifierType) {
            this.identifierType = identifierType;
            return this;
        }

        @Override
        public final Builder identifierType(IdentifierType identifierType) {
            this.identifierType(identifierType == null ? null : identifierType.toString());
            return this;
        }

        public final String getPartnerType() {
            return this.partnerType;
        }

        public final void setPartnerType(String partnerType) {
            this.partnerType = partnerType;
        }

        @Override
        public final Builder partnerType(String partnerType) {
            this.partnerType = partnerType;
            return this;
        }

        @Override
        public final Builder partnerType(EventNotificationPartnerType partnerType) {
            this.partnerType(partnerType == null ? null : partnerType.toString());
            return this;
        }

        public final EventNotificationItemConfigurations.Builder getEvents() {
            return this.events != null ? this.events.toBuilder() : null;
        }

        public final void setEvents(EventNotificationItemConfigurations.BuilderImpl events) {
            this.events = events != null ? events.build() : null;
        }

        @Override
        public final Builder events(EventNotificationItemConfigurations events) {
            this.events = events;
            return this;
        }

        public EventConfigurationItem build() {
            return new EventConfigurationItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventConfigurationItem> {
        public Builder identifier(String var1);

        public Builder identifierType(String var1);

        public Builder identifierType(IdentifierType var1);

        public Builder partnerType(String var1);

        public Builder partnerType(EventNotificationPartnerType var1);

        public Builder events(EventNotificationItemConfigurations var1);

        default public Builder events(Consumer<EventNotificationItemConfigurations.Builder> events) {
            return this.events((EventNotificationItemConfigurations)((EventNotificationItemConfigurations.Builder)EventNotificationItemConfigurations.builder().applyMutation(events)).build());
        }
    }
}

