/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.MulticastWirelessMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendDataToMulticastGroupRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, SendDataToMulticastGroupRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(SendDataToMulticastGroupRequest.getter(SendDataToMulticastGroupRequest::id)).setter(SendDataToMulticastGroupRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()}).build();
    private static final SdkField<String> PAYLOAD_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PayloadData").getter(SendDataToMulticastGroupRequest.getter(SendDataToMulticastGroupRequest::payloadData)).setter(SendDataToMulticastGroupRequest.setter(Builder::payloadData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadData").build()}).build();
    private static final SdkField<MulticastWirelessMetadata> WIRELESS_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WirelessMetadata").getter(SendDataToMulticastGroupRequest.getter(SendDataToMulticastGroupRequest::wirelessMetadata)).setter(SendDataToMulticastGroupRequest.setter(Builder::wirelessMetadata)).constructor(MulticastWirelessMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PAYLOAD_DATA_FIELD, WIRELESS_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("PayloadData", PAYLOAD_DATA_FIELD);
            this.put("WirelessMetadata", WIRELESS_METADATA_FIELD);
        }
    });
    private final String id;
    private final String payloadData;
    private final MulticastWirelessMetadata wirelessMetadata;

    private SendDataToMulticastGroupRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.payloadData = builder.payloadData;
        this.wirelessMetadata = builder.wirelessMetadata;
    }

    public final String id() {
        return this.id;
    }

    public final String payloadData() {
        return this.payloadData;
    }

    public final MulticastWirelessMetadata wirelessMetadata() {
        return this.wirelessMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadData());
        hashCode = 31 * hashCode + Objects.hashCode(this.wirelessMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendDataToMulticastGroupRequest)) {
            return false;
        }
        SendDataToMulticastGroupRequest other = (SendDataToMulticastGroupRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.payloadData(), other.payloadData()) && Objects.equals(this.wirelessMetadata(), other.wirelessMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"SendDataToMulticastGroupRequest").add("Id", (Object)this.id()).add("PayloadData", (Object)this.payloadData()).add("WirelessMetadata", (Object)this.wirelessMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "PayloadData": {
                return Optional.ofNullable(clazz.cast(this.payloadData()));
            }
            case "WirelessMetadata": {
                return Optional.ofNullable(clazz.cast(this.wirelessMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SendDataToMulticastGroupRequest, T> g) {
        return obj -> g.apply((SendDataToMulticastGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String id;
        private String payloadData;
        private MulticastWirelessMetadata wirelessMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(SendDataToMulticastGroupRequest model) {
            super(model);
            this.id(model.id);
            this.payloadData(model.payloadData);
            this.wirelessMetadata(model.wirelessMetadata);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getPayloadData() {
            return this.payloadData;
        }

        public final void setPayloadData(String payloadData) {
            this.payloadData = payloadData;
        }

        @Override
        public final Builder payloadData(String payloadData) {
            this.payloadData = payloadData;
            return this;
        }

        public final MulticastWirelessMetadata.Builder getWirelessMetadata() {
            return this.wirelessMetadata != null ? this.wirelessMetadata.toBuilder() : null;
        }

        public final void setWirelessMetadata(MulticastWirelessMetadata.BuilderImpl wirelessMetadata) {
            this.wirelessMetadata = wirelessMetadata != null ? wirelessMetadata.build() : null;
        }

        @Override
        public final Builder wirelessMetadata(MulticastWirelessMetadata wirelessMetadata) {
            this.wirelessMetadata = wirelessMetadata;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendDataToMulticastGroupRequest build() {
            return new SendDataToMulticastGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendDataToMulticastGroupRequest> {
        public Builder id(String var1);

        public Builder payloadData(String var1);

        public Builder wirelessMetadata(MulticastWirelessMetadata var1);

        default public Builder wirelessMetadata(Consumer<MulticastWirelessMetadata.Builder> wirelessMetadata) {
            return this.wirelessMetadata((MulticastWirelessMetadata)((MulticastWirelessMetadata.Builder)MulticastWirelessMetadata.builder().applyMutation(wirelessMetadata)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

