/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.ConnectionStatusEventConfiguration;
import software.amazon.awssdk.services.iotwireless.model.DeviceRegistrationStateEventConfiguration;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.JoinEventConfiguration;
import software.amazon.awssdk.services.iotwireless.model.MessageDeliveryStatusEventConfiguration;
import software.amazon.awssdk.services.iotwireless.model.ProximityEventConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceEventConfigurationResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, GetResourceEventConfigurationResponse> {
    private static final SdkField<DeviceRegistrationStateEventConfiguration> DEVICE_REGISTRATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceRegistrationState").getter(GetResourceEventConfigurationResponse.getter(GetResourceEventConfigurationResponse::deviceRegistrationState)).setter(GetResourceEventConfigurationResponse.setter(Builder::deviceRegistrationState)).constructor(DeviceRegistrationStateEventConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceRegistrationState").build()}).build();
    private static final SdkField<ProximityEventConfiguration> PROXIMITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Proximity").getter(GetResourceEventConfigurationResponse.getter(GetResourceEventConfigurationResponse::proximity)).setter(GetResourceEventConfigurationResponse.setter(Builder::proximity)).constructor(ProximityEventConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Proximity").build()}).build();
    private static final SdkField<JoinEventConfiguration> JOIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Join").getter(GetResourceEventConfigurationResponse.getter(GetResourceEventConfigurationResponse::join)).setter(GetResourceEventConfigurationResponse.setter(Builder::join)).constructor(JoinEventConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Join").build()}).build();
    private static final SdkField<ConnectionStatusEventConfiguration> CONNECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionStatus").getter(GetResourceEventConfigurationResponse.getter(GetResourceEventConfigurationResponse::connectionStatus)).setter(GetResourceEventConfigurationResponse.setter(Builder::connectionStatus)).constructor(ConnectionStatusEventConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()}).build();
    private static final SdkField<MessageDeliveryStatusEventConfiguration> MESSAGE_DELIVERY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MessageDeliveryStatus").getter(GetResourceEventConfigurationResponse.getter(GetResourceEventConfigurationResponse::messageDeliveryStatus)).setter(GetResourceEventConfigurationResponse.setter(Builder::messageDeliveryStatus)).constructor(MessageDeliveryStatusEventConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageDeliveryStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_REGISTRATION_STATE_FIELD, PROXIMITY_FIELD, JOIN_FIELD, CONNECTION_STATUS_FIELD, MESSAGE_DELIVERY_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DeviceRegistrationState", DEVICE_REGISTRATION_STATE_FIELD);
            this.put("Proximity", PROXIMITY_FIELD);
            this.put("Join", JOIN_FIELD);
            this.put("ConnectionStatus", CONNECTION_STATUS_FIELD);
            this.put("MessageDeliveryStatus", MESSAGE_DELIVERY_STATUS_FIELD);
        }
    });
    private final DeviceRegistrationStateEventConfiguration deviceRegistrationState;
    private final ProximityEventConfiguration proximity;
    private final JoinEventConfiguration join;
    private final ConnectionStatusEventConfiguration connectionStatus;
    private final MessageDeliveryStatusEventConfiguration messageDeliveryStatus;

    private GetResourceEventConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.deviceRegistrationState = builder.deviceRegistrationState;
        this.proximity = builder.proximity;
        this.join = builder.join;
        this.connectionStatus = builder.connectionStatus;
        this.messageDeliveryStatus = builder.messageDeliveryStatus;
    }

    public final DeviceRegistrationStateEventConfiguration deviceRegistrationState() {
        return this.deviceRegistrationState;
    }

    public final ProximityEventConfiguration proximity() {
        return this.proximity;
    }

    public final JoinEventConfiguration join() {
        return this.join;
    }

    public final ConnectionStatusEventConfiguration connectionStatus() {
        return this.connectionStatus;
    }

    public final MessageDeliveryStatusEventConfiguration messageDeliveryStatus() {
        return this.messageDeliveryStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceRegistrationState());
        hashCode = 31 * hashCode + Objects.hashCode(this.proximity());
        hashCode = 31 * hashCode + Objects.hashCode(this.join());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageDeliveryStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceEventConfigurationResponse)) {
            return false;
        }
        GetResourceEventConfigurationResponse other = (GetResourceEventConfigurationResponse)((Object)obj);
        return Objects.equals(this.deviceRegistrationState(), other.deviceRegistrationState()) && Objects.equals(this.proximity(), other.proximity()) && Objects.equals(this.join(), other.join()) && Objects.equals(this.connectionStatus(), other.connectionStatus()) && Objects.equals(this.messageDeliveryStatus(), other.messageDeliveryStatus());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceEventConfigurationResponse").add("DeviceRegistrationState", (Object)this.deviceRegistrationState()).add("Proximity", (Object)this.proximity()).add("Join", (Object)this.join()).add("ConnectionStatus", (Object)this.connectionStatus()).add("MessageDeliveryStatus", (Object)this.messageDeliveryStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceRegistrationState": {
                return Optional.ofNullable(clazz.cast(this.deviceRegistrationState()));
            }
            case "Proximity": {
                return Optional.ofNullable(clazz.cast(this.proximity()));
            }
            case "Join": {
                return Optional.ofNullable(clazz.cast(this.join()));
            }
            case "ConnectionStatus": {
                return Optional.ofNullable(clazz.cast(this.connectionStatus()));
            }
            case "MessageDeliveryStatus": {
                return Optional.ofNullable(clazz.cast(this.messageDeliveryStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceEventConfigurationResponse, T> g) {
        return obj -> g.apply((GetResourceEventConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private DeviceRegistrationStateEventConfiguration deviceRegistrationState;
        private ProximityEventConfiguration proximity;
        private JoinEventConfiguration join;
        private ConnectionStatusEventConfiguration connectionStatus;
        private MessageDeliveryStatusEventConfiguration messageDeliveryStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceEventConfigurationResponse model) {
            super(model);
            this.deviceRegistrationState(model.deviceRegistrationState);
            this.proximity(model.proximity);
            this.join(model.join);
            this.connectionStatus(model.connectionStatus);
            this.messageDeliveryStatus(model.messageDeliveryStatus);
        }

        public final DeviceRegistrationStateEventConfiguration.Builder getDeviceRegistrationState() {
            return this.deviceRegistrationState != null ? this.deviceRegistrationState.toBuilder() : null;
        }

        public final void setDeviceRegistrationState(DeviceRegistrationStateEventConfiguration.BuilderImpl deviceRegistrationState) {
            this.deviceRegistrationState = deviceRegistrationState != null ? deviceRegistrationState.build() : null;
        }

        @Override
        public final Builder deviceRegistrationState(DeviceRegistrationStateEventConfiguration deviceRegistrationState) {
            this.deviceRegistrationState = deviceRegistrationState;
            return this;
        }

        public final ProximityEventConfiguration.Builder getProximity() {
            return this.proximity != null ? this.proximity.toBuilder() : null;
        }

        public final void setProximity(ProximityEventConfiguration.BuilderImpl proximity) {
            this.proximity = proximity != null ? proximity.build() : null;
        }

        @Override
        public final Builder proximity(ProximityEventConfiguration proximity) {
            this.proximity = proximity;
            return this;
        }

        public final JoinEventConfiguration.Builder getJoin() {
            return this.join != null ? this.join.toBuilder() : null;
        }

        public final void setJoin(JoinEventConfiguration.BuilderImpl join) {
            this.join = join != null ? join.build() : null;
        }

        @Override
        public final Builder join(JoinEventConfiguration join) {
            this.join = join;
            return this;
        }

        public final ConnectionStatusEventConfiguration.Builder getConnectionStatus() {
            return this.connectionStatus != null ? this.connectionStatus.toBuilder() : null;
        }

        public final void setConnectionStatus(ConnectionStatusEventConfiguration.BuilderImpl connectionStatus) {
            this.connectionStatus = connectionStatus != null ? connectionStatus.build() : null;
        }

        @Override
        public final Builder connectionStatus(ConnectionStatusEventConfiguration connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        public final MessageDeliveryStatusEventConfiguration.Builder getMessageDeliveryStatus() {
            return this.messageDeliveryStatus != null ? this.messageDeliveryStatus.toBuilder() : null;
        }

        public final void setMessageDeliveryStatus(MessageDeliveryStatusEventConfiguration.BuilderImpl messageDeliveryStatus) {
            this.messageDeliveryStatus = messageDeliveryStatus != null ? messageDeliveryStatus.build() : null;
        }

        @Override
        public final Builder messageDeliveryStatus(MessageDeliveryStatusEventConfiguration messageDeliveryStatus) {
            this.messageDeliveryStatus = messageDeliveryStatus;
            return this;
        }

        @Override
        public GetResourceEventConfigurationResponse build() {
            return new GetResourceEventConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceEventConfigurationResponse> {
        public Builder deviceRegistrationState(DeviceRegistrationStateEventConfiguration var1);

        default public Builder deviceRegistrationState(Consumer<DeviceRegistrationStateEventConfiguration.Builder> deviceRegistrationState) {
            return this.deviceRegistrationState((DeviceRegistrationStateEventConfiguration)((DeviceRegistrationStateEventConfiguration.Builder)DeviceRegistrationStateEventConfiguration.builder().applyMutation(deviceRegistrationState)).build());
        }

        public Builder proximity(ProximityEventConfiguration var1);

        default public Builder proximity(Consumer<ProximityEventConfiguration.Builder> proximity) {
            return this.proximity((ProximityEventConfiguration)((ProximityEventConfiguration.Builder)ProximityEventConfiguration.builder().applyMutation(proximity)).build());
        }

        public Builder join(JoinEventConfiguration var1);

        default public Builder join(Consumer<JoinEventConfiguration.Builder> join) {
            return this.join((JoinEventConfiguration)((JoinEventConfiguration.Builder)JoinEventConfiguration.builder().applyMutation(join)).build());
        }

        public Builder connectionStatus(ConnectionStatusEventConfiguration var1);

        default public Builder connectionStatus(Consumer<ConnectionStatusEventConfiguration.Builder> connectionStatus) {
            return this.connectionStatus((ConnectionStatusEventConfiguration)((ConnectionStatusEventConfiguration.Builder)ConnectionStatusEventConfiguration.builder().applyMutation(connectionStatus)).build());
        }

        public Builder messageDeliveryStatus(MessageDeliveryStatusEventConfiguration var1);

        default public Builder messageDeliveryStatus(Consumer<MessageDeliveryStatusEventConfiguration.Builder> messageDeliveryStatus) {
            return this.messageDeliveryStatus((MessageDeliveryStatusEventConfiguration)((MessageDeliveryStatusEventConfiguration.Builder)MessageDeliveryStatusEventConfiguration.builder().applyMutation(messageDeliveryStatus)).build());
        }
    }
}

