/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.BeaconingFrequenciesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Beaconing
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Beaconing> {
    private static final SdkField<Integer> DATA_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DataRate").getter(Beaconing.getter(Beaconing::dataRate)).setter(Beaconing.setter(Builder::dataRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRate").build()}).build();
    private static final SdkField<List<Integer>> FREQUENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Frequencies").getter(Beaconing.getter(Beaconing::frequencies)).setter(Beaconing.setter(Builder::frequencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_RATE_FIELD, FREQUENCIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataRate", DATA_RATE_FIELD);
            this.put("Frequencies", FREQUENCIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer dataRate;
    private final List<Integer> frequencies;

    private Beaconing(BuilderImpl builder) {
        this.dataRate = builder.dataRate;
        this.frequencies = builder.frequencies;
    }

    public final Integer dataRate() {
        return this.dataRate;
    }

    public final boolean hasFrequencies() {
        return this.frequencies != null && !(this.frequencies instanceof SdkAutoConstructList);
    }

    public final List<Integer> frequencies() {
        return this.frequencies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFrequencies() ? this.frequencies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Beaconing)) {
            return false;
        }
        Beaconing other = (Beaconing)obj;
        return Objects.equals(this.dataRate(), other.dataRate()) && this.hasFrequencies() == other.hasFrequencies() && Objects.equals(this.frequencies(), other.frequencies());
    }

    public final String toString() {
        return ToString.builder((String)"Beaconing").add("DataRate", (Object)this.dataRate()).add("Frequencies", this.hasFrequencies() ? this.frequencies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataRate": {
                return Optional.ofNullable(clazz.cast(this.dataRate()));
            }
            case "Frequencies": {
                return Optional.ofNullable(clazz.cast(this.frequencies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Beaconing, T> g) {
        return obj -> g.apply((Beaconing)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer dataRate;
        private List<Integer> frequencies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Beaconing model) {
            this.dataRate(model.dataRate);
            this.frequencies(model.frequencies);
        }

        public final Integer getDataRate() {
            return this.dataRate;
        }

        public final void setDataRate(Integer dataRate) {
            this.dataRate = dataRate;
        }

        @Override
        public final Builder dataRate(Integer dataRate) {
            this.dataRate = dataRate;
            return this;
        }

        public final Collection<Integer> getFrequencies() {
            if (this.frequencies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.frequencies;
        }

        public final void setFrequencies(Collection<Integer> frequencies) {
            this.frequencies = BeaconingFrequenciesCopier.copy(frequencies);
        }

        @Override
        public final Builder frequencies(Collection<Integer> frequencies) {
            this.frequencies = BeaconingFrequenciesCopier.copy(frequencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frequencies(Integer ... frequencies) {
            this.frequencies(Arrays.asList(frequencies));
            return this;
        }

        public Beaconing build() {
            return new Beaconing(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Beaconing> {
        public Builder dataRate(Integer var1);

        public Builder frequencies(Collection<Integer> var1);

        public Builder frequencies(Integer ... var1);
    }
}

