/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WirelessGatewayTaskStatus {
    PENDING("PENDING"),
    IN_PROGRESS("IN_PROGRESS"),
    FIRST_RETRY("FIRST_RETRY"),
    SECOND_RETRY("SECOND_RETRY"),
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WirelessGatewayTaskStatus> VALUE_MAP;
    private final String value;

    private WirelessGatewayTaskStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WirelessGatewayTaskStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WirelessGatewayTaskStatus> knownValues() {
        EnumSet<WirelessGatewayTaskStatus> knownValues = EnumSet.allOf(WirelessGatewayTaskStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WirelessGatewayTaskStatus.class, WirelessGatewayTaskStatus::toString);
    }
}

