/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricQueryValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricQueryValue> {
    private static final SdkField<Double> MIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Min").getter(MetricQueryValue.getter(MetricQueryValue::min)).setter(MetricQueryValue.setter(Builder::min)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Min").build()}).build();
    private static final SdkField<Double> MAX_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Max").getter(MetricQueryValue.getter(MetricQueryValue::max)).setter(MetricQueryValue.setter(Builder::max)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max").build()}).build();
    private static final SdkField<Double> SUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Sum").getter(MetricQueryValue.getter(MetricQueryValue::sum)).setter(MetricQueryValue.setter(Builder::sum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sum").build()}).build();
    private static final SdkField<Double> AVG_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Avg").getter(MetricQueryValue.getter(MetricQueryValue::avg)).setter(MetricQueryValue.setter(Builder::avg)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Avg").build()}).build();
    private static final SdkField<Double> STD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Std").getter(MetricQueryValue.getter(MetricQueryValue::std)).setter(MetricQueryValue.setter(Builder::std)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Std").build()}).build();
    private static final SdkField<Double> P90_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("P90").getter(MetricQueryValue.getter(MetricQueryValue::p90)).setter(MetricQueryValue.setter(Builder::p90)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("P90").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_FIELD, MAX_FIELD, SUM_FIELD, AVG_FIELD, STD_FIELD, P90_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double min;
    private final Double max;
    private final Double sum;
    private final Double avg;
    private final Double std;
    private final Double p90;

    private MetricQueryValue(BuilderImpl builder) {
        this.min = builder.min;
        this.max = builder.max;
        this.sum = builder.sum;
        this.avg = builder.avg;
        this.std = builder.std;
        this.p90 = builder.p90;
    }

    public final Double min() {
        return this.min;
    }

    public final Double max() {
        return this.max;
    }

    public final Double sum() {
        return this.sum;
    }

    public final Double avg() {
        return this.avg;
    }

    public final Double std() {
        return this.std;
    }

    public final Double p90() {
        return this.p90;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.min());
        hashCode = 31 * hashCode + Objects.hashCode(this.max());
        hashCode = 31 * hashCode + Objects.hashCode(this.sum());
        hashCode = 31 * hashCode + Objects.hashCode(this.avg());
        hashCode = 31 * hashCode + Objects.hashCode(this.std());
        hashCode = 31 * hashCode + Objects.hashCode(this.p90());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricQueryValue)) {
            return false;
        }
        MetricQueryValue other = (MetricQueryValue)obj;
        return Objects.equals(this.min(), other.min()) && Objects.equals(this.max(), other.max()) && Objects.equals(this.sum(), other.sum()) && Objects.equals(this.avg(), other.avg()) && Objects.equals(this.std(), other.std()) && Objects.equals(this.p90(), other.p90());
    }

    public final String toString() {
        return ToString.builder((String)"MetricQueryValue").add("Min", (Object)this.min()).add("Max", (Object)this.max()).add("Sum", (Object)this.sum()).add("Avg", (Object)this.avg()).add("Std", (Object)this.std()).add("P90", (Object)this.p90()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Min": {
                return Optional.ofNullable(clazz.cast(this.min()));
            }
            case "Max": {
                return Optional.ofNullable(clazz.cast(this.max()));
            }
            case "Sum": {
                return Optional.ofNullable(clazz.cast(this.sum()));
            }
            case "Avg": {
                return Optional.ofNullable(clazz.cast(this.avg()));
            }
            case "Std": {
                return Optional.ofNullable(clazz.cast(this.std()));
            }
            case "P90": {
                return Optional.ofNullable(clazz.cast(this.p90()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricQueryValue, T> g) {
        return obj -> g.apply((MetricQueryValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double min;
        private Double max;
        private Double sum;
        private Double avg;
        private Double std;
        private Double p90;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricQueryValue model) {
            this.min(model.min);
            this.max(model.max);
            this.sum(model.sum);
            this.avg(model.avg);
            this.std(model.std);
            this.p90(model.p90);
        }

        public final Double getMin() {
            return this.min;
        }

        public final void setMin(Double min) {
            this.min = min;
        }

        @Override
        public final Builder min(Double min) {
            this.min = min;
            return this;
        }

        public final Double getMax() {
            return this.max;
        }

        public final void setMax(Double max) {
            this.max = max;
        }

        @Override
        public final Builder max(Double max) {
            this.max = max;
            return this;
        }

        public final Double getSum() {
            return this.sum;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final Double getAvg() {
            return this.avg;
        }

        public final void setAvg(Double avg) {
            this.avg = avg;
        }

        @Override
        public final Builder avg(Double avg) {
            this.avg = avg;
            return this;
        }

        public final Double getStd() {
            return this.std;
        }

        public final void setStd(Double std) {
            this.std = std;
        }

        @Override
        public final Builder std(Double std) {
            this.std = std;
            return this;
        }

        public final Double getP90() {
            return this.p90;
        }

        public final void setP90(Double p90) {
            this.p90 = p90;
        }

        @Override
        public final Builder p90(Double p90) {
            this.p90 = p90;
            return this;
        }

        public MetricQueryValue build() {
            return new MetricQueryValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricQueryValue> {
        public Builder min(Double var1);

        public Builder max(Double var1);

        public Builder sum(Double var1);

        public Builder avg(Double var1);

        public Builder std(Double var1);

        public Builder p90(Double var1);
    }
}

