/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoRaWANMulticastSession
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoRaWANMulticastSession> {
    private static final SdkField<Integer> DL_DR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DlDr").getter(LoRaWANMulticastSession.getter(LoRaWANMulticastSession::dlDr)).setter(LoRaWANMulticastSession.setter(Builder::dlDr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DlDr").build()}).build();
    private static final SdkField<Integer> DL_FREQ_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DlFreq").getter(LoRaWANMulticastSession.getter(LoRaWANMulticastSession::dlFreq)).setter(LoRaWANMulticastSession.setter(Builder::dlFreq)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DlFreq").build()}).build();
    private static final SdkField<Instant> SESSION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SessionStartTime").getter(LoRaWANMulticastSession.getter(LoRaWANMulticastSession::sessionStartTime)).setter(LoRaWANMulticastSession.setter(Builder::sessionStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionStartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> SESSION_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionTimeout").getter(LoRaWANMulticastSession.getter(LoRaWANMulticastSession::sessionTimeout)).setter(LoRaWANMulticastSession.setter(Builder::sessionTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionTimeout").build()}).build();
    private static final SdkField<Integer> PING_SLOT_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PingSlotPeriod").getter(LoRaWANMulticastSession.getter(LoRaWANMulticastSession::pingSlotPeriod)).setter(LoRaWANMulticastSession.setter(Builder::pingSlotPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PingSlotPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DL_DR_FIELD, DL_FREQ_FIELD, SESSION_START_TIME_FIELD, SESSION_TIMEOUT_FIELD, PING_SLOT_PERIOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer dlDr;
    private final Integer dlFreq;
    private final Instant sessionStartTime;
    private final Integer sessionTimeout;
    private final Integer pingSlotPeriod;

    private LoRaWANMulticastSession(BuilderImpl builder) {
        this.dlDr = builder.dlDr;
        this.dlFreq = builder.dlFreq;
        this.sessionStartTime = builder.sessionStartTime;
        this.sessionTimeout = builder.sessionTimeout;
        this.pingSlotPeriod = builder.pingSlotPeriod;
    }

    public final Integer dlDr() {
        return this.dlDr;
    }

    public final Integer dlFreq() {
        return this.dlFreq;
    }

    public final Instant sessionStartTime() {
        return this.sessionStartTime;
    }

    public final Integer sessionTimeout() {
        return this.sessionTimeout;
    }

    public final Integer pingSlotPeriod() {
        return this.pingSlotPeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dlDr());
        hashCode = 31 * hashCode + Objects.hashCode(this.dlFreq());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.pingSlotPeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANMulticastSession)) {
            return false;
        }
        LoRaWANMulticastSession other = (LoRaWANMulticastSession)obj;
        return Objects.equals(this.dlDr(), other.dlDr()) && Objects.equals(this.dlFreq(), other.dlFreq()) && Objects.equals(this.sessionStartTime(), other.sessionStartTime()) && Objects.equals(this.sessionTimeout(), other.sessionTimeout()) && Objects.equals(this.pingSlotPeriod(), other.pingSlotPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"LoRaWANMulticastSession").add("DlDr", (Object)this.dlDr()).add("DlFreq", (Object)this.dlFreq()).add("SessionStartTime", (Object)this.sessionStartTime()).add("SessionTimeout", (Object)this.sessionTimeout()).add("PingSlotPeriod", (Object)this.pingSlotPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DlDr": {
                return Optional.ofNullable(clazz.cast(this.dlDr()));
            }
            case "DlFreq": {
                return Optional.ofNullable(clazz.cast(this.dlFreq()));
            }
            case "SessionStartTime": {
                return Optional.ofNullable(clazz.cast(this.sessionStartTime()));
            }
            case "SessionTimeout": {
                return Optional.ofNullable(clazz.cast(this.sessionTimeout()));
            }
            case "PingSlotPeriod": {
                return Optional.ofNullable(clazz.cast(this.pingSlotPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANMulticastSession, T> g) {
        return obj -> g.apply((LoRaWANMulticastSession)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer dlDr;
        private Integer dlFreq;
        private Instant sessionStartTime;
        private Integer sessionTimeout;
        private Integer pingSlotPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANMulticastSession model) {
            this.dlDr(model.dlDr);
            this.dlFreq(model.dlFreq);
            this.sessionStartTime(model.sessionStartTime);
            this.sessionTimeout(model.sessionTimeout);
            this.pingSlotPeriod(model.pingSlotPeriod);
        }

        public final Integer getDlDr() {
            return this.dlDr;
        }

        public final void setDlDr(Integer dlDr) {
            this.dlDr = dlDr;
        }

        @Override
        public final Builder dlDr(Integer dlDr) {
            this.dlDr = dlDr;
            return this;
        }

        public final Integer getDlFreq() {
            return this.dlFreq;
        }

        public final void setDlFreq(Integer dlFreq) {
            this.dlFreq = dlFreq;
        }

        @Override
        public final Builder dlFreq(Integer dlFreq) {
            this.dlFreq = dlFreq;
            return this;
        }

        public final Instant getSessionStartTime() {
            return this.sessionStartTime;
        }

        public final void setSessionStartTime(Instant sessionStartTime) {
            this.sessionStartTime = sessionStartTime;
        }

        @Override
        public final Builder sessionStartTime(Instant sessionStartTime) {
            this.sessionStartTime = sessionStartTime;
            return this;
        }

        public final Integer getSessionTimeout() {
            return this.sessionTimeout;
        }

        public final void setSessionTimeout(Integer sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        @Override
        public final Builder sessionTimeout(Integer sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public final Integer getPingSlotPeriod() {
            return this.pingSlotPeriod;
        }

        public final void setPingSlotPeriod(Integer pingSlotPeriod) {
            this.pingSlotPeriod = pingSlotPeriod;
        }

        @Override
        public final Builder pingSlotPeriod(Integer pingSlotPeriod) {
            this.pingSlotPeriod = pingSlotPeriod;
            return this;
        }

        public LoRaWANMulticastSession build() {
            return new LoRaWANMulticastSession(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoRaWANMulticastSession> {
        public Builder dlDr(Integer var1);

        public Builder dlFreq(Integer var1);

        public Builder sessionStartTime(Instant var1);

        public Builder sessionTimeout(Integer var1);

        public Builder pingSlotPeriod(Integer var1);
    }
}

