/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.WirelessGatewayIdType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWirelessGatewayRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, GetWirelessGatewayRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(GetWirelessGatewayRequest.getter(GetWirelessGatewayRequest::identifier)).setter(GetWirelessGatewayRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()}).build();
    private static final SdkField<String> IDENTIFIER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentifierType").getter(GetWirelessGatewayRequest.getter(GetWirelessGatewayRequest::identifierTypeAsString)).setter(GetWirelessGatewayRequest.setter(Builder::identifierType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("identifierType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, IDENTIFIER_TYPE_FIELD));
    private final String identifier;
    private final String identifierType;

    private GetWirelessGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.identifierType = builder.identifierType;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final WirelessGatewayIdType identifierType() {
        return WirelessGatewayIdType.fromValue(this.identifierType);
    }

    public final String identifierTypeAsString() {
        return this.identifierType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifierTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWirelessGatewayRequest)) {
            return false;
        }
        GetWirelessGatewayRequest other = (GetWirelessGatewayRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.identifierTypeAsString(), other.identifierTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetWirelessGatewayRequest").add("Identifier", (Object)this.identifier()).add("IdentifierType", (Object)this.identifierTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "IdentifierType": {
                return Optional.ofNullable(clazz.cast(this.identifierTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWirelessGatewayRequest, T> g) {
        return obj -> g.apply((GetWirelessGatewayRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private String identifierType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWirelessGatewayRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.identifierType(model.identifierType);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getIdentifierType() {
            return this.identifierType;
        }

        public final void setIdentifierType(String identifierType) {
            this.identifierType = identifierType;
        }

        @Override
        public final Builder identifierType(String identifierType) {
            this.identifierType = identifierType;
            return this;
        }

        @Override
        public final Builder identifierType(WirelessGatewayIdType identifierType) {
            this.identifierType(identifierType == null ? null : identifierType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetWirelessGatewayRequest build() {
            return new GetWirelessGatewayRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWirelessGatewayRequest> {
        public Builder identifier(String var1);

        public Builder identifierType(String var1);

        public Builder identifierType(WirelessGatewayIdType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

