/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.SidewalkUpdateImportInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWirelessDeviceImportTaskRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, UpdateWirelessDeviceImportTaskRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateWirelessDeviceImportTaskRequest.getter(UpdateWirelessDeviceImportTaskRequest::id)).setter(UpdateWirelessDeviceImportTaskRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()}).build();
    private static final SdkField<SidewalkUpdateImportInfo> SIDEWALK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sidewalk").getter(UpdateWirelessDeviceImportTaskRequest.getter(UpdateWirelessDeviceImportTaskRequest::sidewalk)).setter(UpdateWirelessDeviceImportTaskRequest.setter(Builder::sidewalk)).constructor(SidewalkUpdateImportInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SIDEWALK_FIELD));
    private final String id;
    private final SidewalkUpdateImportInfo sidewalk;

    private UpdateWirelessDeviceImportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.sidewalk = builder.sidewalk;
    }

    public final String id() {
        return this.id;
    }

    public final SidewalkUpdateImportInfo sidewalk() {
        return this.sidewalk;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.sidewalk());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWirelessDeviceImportTaskRequest)) {
            return false;
        }
        UpdateWirelessDeviceImportTaskRequest other = (UpdateWirelessDeviceImportTaskRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.sidewalk(), other.sidewalk());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWirelessDeviceImportTaskRequest").add("Id", (Object)this.id()).add("Sidewalk", (Object)this.sidewalk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Sidewalk": {
                return Optional.ofNullable(clazz.cast(this.sidewalk()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWirelessDeviceImportTaskRequest, T> g) {
        return obj -> g.apply((UpdateWirelessDeviceImportTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String id;
        private SidewalkUpdateImportInfo sidewalk;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWirelessDeviceImportTaskRequest model) {
            super(model);
            this.id(model.id);
            this.sidewalk(model.sidewalk);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final SidewalkUpdateImportInfo.Builder getSidewalk() {
            return this.sidewalk != null ? this.sidewalk.toBuilder() : null;
        }

        public final void setSidewalk(SidewalkUpdateImportInfo.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkUpdateImportInfo sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWirelessDeviceImportTaskRequest build() {
            return new UpdateWirelessDeviceImportTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWirelessDeviceImportTaskRequest> {
        public Builder id(String var1);

        public Builder sidewalk(SidewalkUpdateImportInfo var1);

        default public Builder sidewalk(Consumer<SidewalkUpdateImportInfo.Builder> sidewalk) {
            return this.sidewalk((SidewalkUpdateImportInfo)((SidewalkUpdateImportInfo.Builder)SidewalkUpdateImportInfo.builder().applyMutation(sidewalk)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

