/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.AbpV1_0_x;
import software.amazon.awssdk.services.iotwireless.model.AbpV1_1;
import software.amazon.awssdk.services.iotwireless.model.FPorts;
import software.amazon.awssdk.services.iotwireless.model.OtaaV1_0_x;
import software.amazon.awssdk.services.iotwireless.model.OtaaV1_1;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoRaWANDevice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoRaWANDevice> {
    private static final SdkField<String> DEV_EUI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DevEui").getter(LoRaWANDevice.getter(LoRaWANDevice::devEui)).setter(LoRaWANDevice.setter(Builder::devEui)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevEui").build()}).build();
    private static final SdkField<String> DEVICE_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceProfileId").getter(LoRaWANDevice.getter(LoRaWANDevice::deviceProfileId)).setter(LoRaWANDevice.setter(Builder::deviceProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceProfileId").build()}).build();
    private static final SdkField<String> SERVICE_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceProfileId").getter(LoRaWANDevice.getter(LoRaWANDevice::serviceProfileId)).setter(LoRaWANDevice.setter(Builder::serviceProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceProfileId").build()}).build();
    private static final SdkField<OtaaV1_1> OTAA_V1_1_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OtaaV1_1").getter(LoRaWANDevice.getter(LoRaWANDevice::otaaV1_1)).setter(LoRaWANDevice.setter(Builder::otaaV1_1)).constructor(OtaaV1_1::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaaV1_1").build()}).build();
    private static final SdkField<OtaaV1_0_x> OTAA_V1_0_X_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OtaaV1_0_x").getter(LoRaWANDevice.getter(LoRaWANDevice::otaaV1_0_x)).setter(LoRaWANDevice.setter(Builder::otaaV1_0_x)).constructor(OtaaV1_0_x::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtaaV1_0_x").build()}).build();
    private static final SdkField<AbpV1_1> ABP_V1_1_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AbpV1_1").getter(LoRaWANDevice.getter(LoRaWANDevice::abpV1_1)).setter(LoRaWANDevice.setter(Builder::abpV1_1)).constructor(AbpV1_1::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbpV1_1").build()}).build();
    private static final SdkField<AbpV1_0_x> ABP_V1_0_X_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AbpV1_0_x").getter(LoRaWANDevice.getter(LoRaWANDevice::abpV1_0_x)).setter(LoRaWANDevice.setter(Builder::abpV1_0_x)).constructor(AbpV1_0_x::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbpV1_0_x").build()}).build();
    private static final SdkField<FPorts> F_PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FPorts").getter(LoRaWANDevice.getter(LoRaWANDevice::fPorts)).setter(LoRaWANDevice.setter(Builder::fPorts)).constructor(FPorts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FPorts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEV_EUI_FIELD, DEVICE_PROFILE_ID_FIELD, SERVICE_PROFILE_ID_FIELD, OTAA_V1_1_FIELD, OTAA_V1_0_X_FIELD, ABP_V1_1_FIELD, ABP_V1_0_X_FIELD, F_PORTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String devEui;
    private final String deviceProfileId;
    private final String serviceProfileId;
    private final OtaaV1_1 otaaV1_1;
    private final OtaaV1_0_x otaaV1_0_x;
    private final AbpV1_1 abpV1_1;
    private final AbpV1_0_x abpV1_0_x;
    private final FPorts fPorts;

    private LoRaWANDevice(BuilderImpl builder) {
        this.devEui = builder.devEui;
        this.deviceProfileId = builder.deviceProfileId;
        this.serviceProfileId = builder.serviceProfileId;
        this.otaaV1_1 = builder.otaaV1_1;
        this.otaaV1_0_x = builder.otaaV1_0_x;
        this.abpV1_1 = builder.abpV1_1;
        this.abpV1_0_x = builder.abpV1_0_x;
        this.fPorts = builder.fPorts;
    }

    public final String devEui() {
        return this.devEui;
    }

    public final String deviceProfileId() {
        return this.deviceProfileId;
    }

    public final String serviceProfileId() {
        return this.serviceProfileId;
    }

    public final OtaaV1_1 otaaV1_1() {
        return this.otaaV1_1;
    }

    public final OtaaV1_0_x otaaV1_0_x() {
        return this.otaaV1_0_x;
    }

    public final AbpV1_1 abpV1_1() {
        return this.abpV1_1;
    }

    public final AbpV1_0_x abpV1_0_x() {
        return this.abpV1_0_x;
    }

    public final FPorts fPorts() {
        return this.fPorts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.devEui());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaaV1_1());
        hashCode = 31 * hashCode + Objects.hashCode(this.otaaV1_0_x());
        hashCode = 31 * hashCode + Objects.hashCode(this.abpV1_1());
        hashCode = 31 * hashCode + Objects.hashCode(this.abpV1_0_x());
        hashCode = 31 * hashCode + Objects.hashCode(this.fPorts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANDevice)) {
            return false;
        }
        LoRaWANDevice other = (LoRaWANDevice)obj;
        return Objects.equals(this.devEui(), other.devEui()) && Objects.equals(this.deviceProfileId(), other.deviceProfileId()) && Objects.equals(this.serviceProfileId(), other.serviceProfileId()) && Objects.equals(this.otaaV1_1(), other.otaaV1_1()) && Objects.equals(this.otaaV1_0_x(), other.otaaV1_0_x()) && Objects.equals(this.abpV1_1(), other.abpV1_1()) && Objects.equals(this.abpV1_0_x(), other.abpV1_0_x()) && Objects.equals(this.fPorts(), other.fPorts());
    }

    public final String toString() {
        return ToString.builder((String)"LoRaWANDevice").add("DevEui", (Object)this.devEui()).add("DeviceProfileId", (Object)this.deviceProfileId()).add("ServiceProfileId", (Object)this.serviceProfileId()).add("OtaaV1_1", (Object)this.otaaV1_1()).add("OtaaV1_0_x", (Object)this.otaaV1_0_x()).add("AbpV1_1", (Object)this.abpV1_1()).add("AbpV1_0_x", (Object)this.abpV1_0_x()).add("FPorts", (Object)this.fPorts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DevEui": {
                return Optional.ofNullable(clazz.cast(this.devEui()));
            }
            case "DeviceProfileId": {
                return Optional.ofNullable(clazz.cast(this.deviceProfileId()));
            }
            case "ServiceProfileId": {
                return Optional.ofNullable(clazz.cast(this.serviceProfileId()));
            }
            case "OtaaV1_1": {
                return Optional.ofNullable(clazz.cast(this.otaaV1_1()));
            }
            case "OtaaV1_0_x": {
                return Optional.ofNullable(clazz.cast(this.otaaV1_0_x()));
            }
            case "AbpV1_1": {
                return Optional.ofNullable(clazz.cast(this.abpV1_1()));
            }
            case "AbpV1_0_x": {
                return Optional.ofNullable(clazz.cast(this.abpV1_0_x()));
            }
            case "FPorts": {
                return Optional.ofNullable(clazz.cast(this.fPorts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANDevice, T> g) {
        return obj -> g.apply((LoRaWANDevice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String devEui;
        private String deviceProfileId;
        private String serviceProfileId;
        private OtaaV1_1 otaaV1_1;
        private OtaaV1_0_x otaaV1_0_x;
        private AbpV1_1 abpV1_1;
        private AbpV1_0_x abpV1_0_x;
        private FPorts fPorts;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANDevice model) {
            this.devEui(model.devEui);
            this.deviceProfileId(model.deviceProfileId);
            this.serviceProfileId(model.serviceProfileId);
            this.otaaV1_1(model.otaaV1_1);
            this.otaaV1_0_x(model.otaaV1_0_x);
            this.abpV1_1(model.abpV1_1);
            this.abpV1_0_x(model.abpV1_0_x);
            this.fPorts(model.fPorts);
        }

        public final String getDevEui() {
            return this.devEui;
        }

        public final void setDevEui(String devEui) {
            this.devEui = devEui;
        }

        @Override
        public final Builder devEui(String devEui) {
            this.devEui = devEui;
            return this;
        }

        public final String getDeviceProfileId() {
            return this.deviceProfileId;
        }

        public final void setDeviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
        }

        @Override
        public final Builder deviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
            return this;
        }

        public final String getServiceProfileId() {
            return this.serviceProfileId;
        }

        public final void setServiceProfileId(String serviceProfileId) {
            this.serviceProfileId = serviceProfileId;
        }

        @Override
        public final Builder serviceProfileId(String serviceProfileId) {
            this.serviceProfileId = serviceProfileId;
            return this;
        }

        public final OtaaV1_1.Builder getOtaaV1_1() {
            return this.otaaV1_1 != null ? this.otaaV1_1.toBuilder() : null;
        }

        public final void setOtaaV1_1(OtaaV1_1.BuilderImpl otaaV1_1) {
            this.otaaV1_1 = otaaV1_1 != null ? otaaV1_1.build() : null;
        }

        @Override
        public final Builder otaaV1_1(OtaaV1_1 otaaV1_1) {
            this.otaaV1_1 = otaaV1_1;
            return this;
        }

        public final OtaaV1_0_x.Builder getOtaaV1_0_x() {
            return this.otaaV1_0_x != null ? this.otaaV1_0_x.toBuilder() : null;
        }

        public final void setOtaaV1_0_x(OtaaV1_0_x.BuilderImpl otaaV1_0_x) {
            this.otaaV1_0_x = otaaV1_0_x != null ? otaaV1_0_x.build() : null;
        }

        @Override
        public final Builder otaaV1_0_x(OtaaV1_0_x otaaV1_0_x) {
            this.otaaV1_0_x = otaaV1_0_x;
            return this;
        }

        public final AbpV1_1.Builder getAbpV1_1() {
            return this.abpV1_1 != null ? this.abpV1_1.toBuilder() : null;
        }

        public final void setAbpV1_1(AbpV1_1.BuilderImpl abpV1_1) {
            this.abpV1_1 = abpV1_1 != null ? abpV1_1.build() : null;
        }

        @Override
        public final Builder abpV1_1(AbpV1_1 abpV1_1) {
            this.abpV1_1 = abpV1_1;
            return this;
        }

        public final AbpV1_0_x.Builder getAbpV1_0_x() {
            return this.abpV1_0_x != null ? this.abpV1_0_x.toBuilder() : null;
        }

        public final void setAbpV1_0_x(AbpV1_0_x.BuilderImpl abpV1_0_x) {
            this.abpV1_0_x = abpV1_0_x != null ? abpV1_0_x.build() : null;
        }

        @Override
        public final Builder abpV1_0_x(AbpV1_0_x abpV1_0_x) {
            this.abpV1_0_x = abpV1_0_x;
            return this;
        }

        public final FPorts.Builder getFPorts() {
            return this.fPorts != null ? this.fPorts.toBuilder() : null;
        }

        public final void setFPorts(FPorts.BuilderImpl fPorts) {
            this.fPorts = fPorts != null ? fPorts.build() : null;
        }

        @Override
        public final Builder fPorts(FPorts fPorts) {
            this.fPorts = fPorts;
            return this;
        }

        public LoRaWANDevice build() {
            return new LoRaWANDevice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoRaWANDevice> {
        public Builder devEui(String var1);

        public Builder deviceProfileId(String var1);

        public Builder serviceProfileId(String var1);

        public Builder otaaV1_1(OtaaV1_1 var1);

        default public Builder otaaV1_1(Consumer<OtaaV1_1.Builder> otaaV1_1) {
            return this.otaaV1_1((OtaaV1_1)((OtaaV1_1.Builder)OtaaV1_1.builder().applyMutation(otaaV1_1)).build());
        }

        public Builder otaaV1_0_x(OtaaV1_0_x var1);

        default public Builder otaaV1_0_x(Consumer<OtaaV1_0_x.Builder> otaaV1_0_x) {
            return this.otaaV1_0_x((OtaaV1_0_x)((OtaaV1_0_x.Builder)OtaaV1_0_x.builder().applyMutation(otaaV1_0_x)).build());
        }

        public Builder abpV1_1(AbpV1_1 var1);

        default public Builder abpV1_1(Consumer<AbpV1_1.Builder> abpV1_1) {
            return this.abpV1_1((AbpV1_1)((AbpV1_1.Builder)AbpV1_1.builder().applyMutation(abpV1_1)).build());
        }

        public Builder abpV1_0_x(AbpV1_0_x var1);

        default public Builder abpV1_0_x(Consumer<AbpV1_0_x.Builder> abpV1_0_x) {
            return this.abpV1_0_x((AbpV1_0_x)((AbpV1_0_x.Builder)AbpV1_0_x.builder().applyMutation(abpV1_0_x)).build());
        }

        public Builder fPorts(FPorts var1);

        default public Builder fPorts(Consumer<FPorts.Builder> fPorts) {
            return this.fPorts((FPorts)((FPorts.Builder)FPorts.builder().applyMutation(fPorts)).build());
        }
    }
}

