/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessClient;
import software.amazon.awssdk.services.iotwireless.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse;

public class ListDestinationsIterable
implements SdkIterable<ListDestinationsResponse> {
    private final IotWirelessClient client;
    private final ListDestinationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDestinationsIterable(IotWirelessClient client, ListDestinationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDestinationsResponseFetcher();
    }

    public Iterator<ListDestinationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDestinationsResponseFetcher
    implements SyncPageFetcher<ListDestinationsResponse> {
        private ListDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDestinationsResponse nextPage(ListDestinationsResponse previousPage) {
            if (previousPage == null) {
                return ListDestinationsIterable.this.client.listDestinations(ListDestinationsIterable.this.firstRequest);
            }
            return ListDestinationsIterable.this.client.listDestinations((ListDestinationsRequest)((Object)ListDestinationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

