/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessClient;
import software.amazon.awssdk.services.iotwireless.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse;

public class ListNetworkAnalyzerConfigurationsIterable
implements SdkIterable<ListNetworkAnalyzerConfigurationsResponse> {
    private final IotWirelessClient client;
    private final ListNetworkAnalyzerConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNetworkAnalyzerConfigurationsIterable(IotWirelessClient client, ListNetworkAnalyzerConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListNetworkAnalyzerConfigurationsResponseFetcher();
    }

    public Iterator<ListNetworkAnalyzerConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListNetworkAnalyzerConfigurationsResponseFetcher
    implements SyncPageFetcher<ListNetworkAnalyzerConfigurationsResponse> {
        private ListNetworkAnalyzerConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListNetworkAnalyzerConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNetworkAnalyzerConfigurationsResponse nextPage(ListNetworkAnalyzerConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListNetworkAnalyzerConfigurationsIterable.this.client.listNetworkAnalyzerConfigurations(ListNetworkAnalyzerConfigurationsIterable.this.firstRequest);
            }
            return ListNetworkAnalyzerConfigurationsIterable.this.client.listNetworkAnalyzerConfigurations((ListNetworkAnalyzerConfigurationsRequest)((Object)ListNetworkAnalyzerConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

