/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessAsyncClient;
import software.amazon.awssdk.services.iotwireless.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsResponse;

public class ListMulticastGroupsPublisher
implements SdkPublisher<ListMulticastGroupsResponse> {
    private final IotWirelessAsyncClient client;
    private final ListMulticastGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMulticastGroupsPublisher(IotWirelessAsyncClient client, ListMulticastGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMulticastGroupsPublisher(IotWirelessAsyncClient client, ListMulticastGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMulticastGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMulticastGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMulticastGroupsResponseFetcher
    implements AsyncPageFetcher<ListMulticastGroupsResponse> {
        private ListMulticastGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListMulticastGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMulticastGroupsResponse> nextPage(ListMulticastGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListMulticastGroupsPublisher.this.client.listMulticastGroups(ListMulticastGroupsPublisher.this.firstRequest);
            }
            return ListMulticastGroupsPublisher.this.client.listMulticastGroups((ListMulticastGroupsRequest)((Object)ListMulticastGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

