/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApplicationConfigType {
    SEMTECH_GEOLOCATION("SemtechGeolocation"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApplicationConfigType> VALUE_MAP;
    private final String value;

    private ApplicationConfigType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApplicationConfigType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApplicationConfigType> knownValues() {
        EnumSet<ApplicationConfigType> knownValues = EnumSet.allOf(ApplicationConfigType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApplicationConfigType.class, ApplicationConfigType::toString);
    }
}

