/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PositionSolverProvider {
    SEMTECH("Semtech"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PositionSolverProvider> VALUE_MAP;
    private final String value;

    private PositionSolverProvider(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PositionSolverProvider fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PositionSolverProvider> knownValues() {
        EnumSet<PositionSolverProvider> knownValues = EnumSet.allOf(PositionSolverProvider.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PositionSolverProvider.class, PositionSolverProvider::toString);
    }
}

