/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.DestinationListCopier;
import software.amazon.awssdk.services.iotwireless.model.Destinations;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDestinationsResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, ListDestinationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDestinationsResponse.getter(ListDestinationsResponse::nextToken)).setter(ListDestinationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<Destinations>> DESTINATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationList").getter(ListDestinationsResponse.getter(ListDestinationsResponse::destinationList)).setter(ListDestinationsResponse.setter(Builder::destinationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Destinations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, DESTINATION_LIST_FIELD));
    private final String nextToken;
    private final List<Destinations> destinationList;

    private ListDestinationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.destinationList = builder.destinationList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasDestinationList() {
        return this.destinationList != null && !(this.destinationList instanceof SdkAutoConstructList);
    }

    public final List<Destinations> destinationList() {
        return this.destinationList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationList() ? this.destinationList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDestinationsResponse)) {
            return false;
        }
        ListDestinationsResponse other = (ListDestinationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasDestinationList() == other.hasDestinationList() && Objects.equals(this.destinationList(), other.destinationList());
    }

    public final String toString() {
        return ToString.builder((String)"ListDestinationsResponse").add("NextToken", (Object)this.nextToken()).add("DestinationList", this.hasDestinationList() ? this.destinationList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DestinationList": {
                return Optional.ofNullable(clazz.cast(this.destinationList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDestinationsResponse, T> g) {
        return obj -> g.apply((ListDestinationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Destinations> destinationList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDestinationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.destinationList(model.destinationList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Destinations.Builder> getDestinationList() {
            List<Destinations.Builder> result = DestinationListCopier.copyToBuilder(this.destinationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationList(Collection<Destinations.BuilderImpl> destinationList) {
            this.destinationList = DestinationListCopier.copyFromBuilder(destinationList);
        }

        @Override
        public final Builder destinationList(Collection<Destinations> destinationList) {
            this.destinationList = DestinationListCopier.copy(destinationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationList(Destinations ... destinationList) {
            this.destinationList(Arrays.asList(destinationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationList(Consumer<Destinations.Builder> ... destinationList) {
            this.destinationList(Stream.of(destinationList).map(c -> (Destinations)((Destinations.Builder)Destinations.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDestinationsResponse build() {
            return new ListDestinationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDestinationsResponse> {
        public Builder nextToken(String var1);

        public Builder destinationList(Collection<Destinations> var1);

        public Builder destinationList(Destinations ... var1);

        public Builder destinationList(Consumer<Destinations.Builder> ... var1);
    }
}

