/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WirelessGatewayServiceType {
    CUPS("CUPS"),
    LNS("LNS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WirelessGatewayServiceType> VALUE_MAP;
    private final String value;

    private WirelessGatewayServiceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WirelessGatewayServiceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WirelessGatewayServiceType> knownValues() {
        EnumSet<WirelessGatewayServiceType> knownValues = EnumSet.allOf(WirelessGatewayServiceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WirelessGatewayServiceType.class, WirelessGatewayServiceType::toString);
    }
}

