/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.PositionConfigurationFec;
import software.amazon.awssdk.services.iotwireless.model.PositionConfigurationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SemtechGnssConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SemtechGnssConfiguration> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SemtechGnssConfiguration.getter(SemtechGnssConfiguration::statusAsString)).setter(SemtechGnssConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Fec").getter(SemtechGnssConfiguration.getter(SemtechGnssConfiguration::fecAsString)).setter(SemtechGnssConfiguration.setter(Builder::fec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, FEC_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String fec;

    private SemtechGnssConfiguration(BuilderImpl builder) {
        this.status = builder.status;
        this.fec = builder.fec;
    }

    public final PositionConfigurationStatus status() {
        return PositionConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final PositionConfigurationFec fec() {
        return PositionConfigurationFec.fromValue(this.fec);
    }

    public final String fecAsString() {
        return this.fec;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fecAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SemtechGnssConfiguration)) {
            return false;
        }
        SemtechGnssConfiguration other = (SemtechGnssConfiguration)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.fecAsString(), other.fecAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SemtechGnssConfiguration").add("Status", (Object)this.statusAsString()).add("Fec", (Object)this.fecAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Fec": {
                return Optional.ofNullable(clazz.cast(this.fecAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SemtechGnssConfiguration, T> g) {
        return obj -> g.apply((SemtechGnssConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String fec;

        private BuilderImpl() {
        }

        private BuilderImpl(SemtechGnssConfiguration model) {
            this.status(model.status);
            this.fec(model.fec);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PositionConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFec() {
            return this.fec;
        }

        public final void setFec(String fec) {
            this.fec = fec;
        }

        @Override
        public final Builder fec(String fec) {
            this.fec = fec;
            return this;
        }

        @Override
        public final Builder fec(PositionConfigurationFec fec) {
            this.fec(fec == null ? null : fec.toString());
            return this;
        }

        public SemtechGnssConfiguration build() {
            return new SemtechGnssConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SemtechGnssConfiguration> {
        public Builder status(String var1);

        public Builder status(PositionConfigurationStatus var1);

        public Builder fec(String var1);

        public Builder fec(PositionConfigurationFec var1);
    }
}

