/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.ApplicationConfigType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationConfig> {
    private static final SdkField<Integer> F_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FPort").getter(ApplicationConfig.getter(ApplicationConfig::fPort)).setter(ApplicationConfig.setter(Builder::fPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FPort").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ApplicationConfig.getter(ApplicationConfig::typeAsString)).setter(ApplicationConfig.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationName").getter(ApplicationConfig.getter(ApplicationConfig::destinationName)).setter(ApplicationConfig.setter(Builder::destinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(F_PORT_FIELD, TYPE_FIELD, DESTINATION_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer fPort;
    private final String type;
    private final String destinationName;

    private ApplicationConfig(BuilderImpl builder) {
        this.fPort = builder.fPort;
        this.type = builder.type;
        this.destinationName = builder.destinationName;
    }

    public final Integer fPort() {
        return this.fPort;
    }

    public final ApplicationConfigType type() {
        return ApplicationConfigType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String destinationName() {
        return this.destinationName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationConfig)) {
            return false;
        }
        ApplicationConfig other = (ApplicationConfig)obj;
        return Objects.equals(this.fPort(), other.fPort()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.destinationName(), other.destinationName());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationConfig").add("FPort", (Object)this.fPort()).add("Type", (Object)this.typeAsString()).add("DestinationName", (Object)this.destinationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FPort": {
                return Optional.ofNullable(clazz.cast(this.fPort()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "DestinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationConfig, T> g) {
        return obj -> g.apply((ApplicationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer fPort;
        private String type;
        private String destinationName;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationConfig model) {
            this.fPort(model.fPort);
            this.type(model.type);
            this.destinationName(model.destinationName);
        }

        public final Integer getFPort() {
            return this.fPort;
        }

        public final void setFPort(Integer fPort) {
            this.fPort = fPort;
        }

        @Override
        public final Builder fPort(Integer fPort) {
            this.fPort = fPort;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ApplicationConfigType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public ApplicationConfig build() {
            return new ApplicationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationConfig> {
        public Builder fPort(Integer var1);

        public Builder type(String var1);

        public Builder type(ApplicationConfigType var1);

        public Builder destinationName(String var1);
    }
}

