/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.PositionResourceType;
import software.amazon.awssdk.services.iotwireless.model.PositionSolverDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PositionConfigurationItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PositionConfigurationItem> {
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdentifier").getter(PositionConfigurationItem.getter(PositionConfigurationItem::resourceIdentifier)).setter(PositionConfigurationItem.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(PositionConfigurationItem.getter(PositionConfigurationItem::resourceTypeAsString)).setter(PositionConfigurationItem.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<PositionSolverDetails> SOLVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Solvers").getter(PositionConfigurationItem.getter(PositionConfigurationItem::solvers)).setter(PositionConfigurationItem.setter(Builder::solvers)).constructor(PositionSolverDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Solvers").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(PositionConfigurationItem.getter(PositionConfigurationItem::destination)).setter(PositionConfigurationItem.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIER_FIELD, RESOURCE_TYPE_FIELD, SOLVERS_FIELD, DESTINATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceIdentifier;
    private final String resourceType;
    private final PositionSolverDetails solvers;
    private final String destination;

    private PositionConfigurationItem(BuilderImpl builder) {
        this.resourceIdentifier = builder.resourceIdentifier;
        this.resourceType = builder.resourceType;
        this.solvers = builder.solvers;
        this.destination = builder.destination;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final PositionResourceType resourceType() {
        return PositionResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final PositionSolverDetails solvers() {
        return this.solvers;
    }

    public final String destination() {
        return this.destination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.solvers());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PositionConfigurationItem)) {
            return false;
        }
        PositionConfigurationItem other = (PositionConfigurationItem)obj;
        return Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.solvers(), other.solvers()) && Objects.equals(this.destination(), other.destination());
    }

    public final String toString() {
        return ToString.builder((String)"PositionConfigurationItem").add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Solvers", (Object)this.solvers()).add("Destination", (Object)this.destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "Solvers": {
                return Optional.ofNullable(clazz.cast(this.solvers()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PositionConfigurationItem, T> g) {
        return obj -> g.apply((PositionConfigurationItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceIdentifier;
        private String resourceType;
        private PositionSolverDetails solvers;
        private String destination;

        private BuilderImpl() {
        }

        private BuilderImpl(PositionConfigurationItem model) {
            this.resourceIdentifier(model.resourceIdentifier);
            this.resourceType(model.resourceType);
            this.solvers(model.solvers);
            this.destination(model.destination);
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(PositionResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final PositionSolverDetails.Builder getSolvers() {
            return this.solvers != null ? this.solvers.toBuilder() : null;
        }

        public final void setSolvers(PositionSolverDetails.BuilderImpl solvers) {
            this.solvers = solvers != null ? solvers.build() : null;
        }

        @Override
        public final Builder solvers(PositionSolverDetails solvers) {
            this.solvers = solvers;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public PositionConfigurationItem build() {
            return new PositionConfigurationItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PositionConfigurationItem> {
        public Builder resourceIdentifier(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(PositionResourceType var1);

        public Builder solvers(PositionSolverDetails var1);

        default public Builder solvers(Consumer<PositionSolverDetails.Builder> solvers) {
            return this.solvers((PositionSolverDetails)((PositionSolverDetails.Builder)PositionSolverDetails.builder().applyMutation(solvers)).build());
        }

        public Builder destination(String var1);
    }
}

