/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * TD-SCDMA object for network measurement reports.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TdscdmaNmrObj implements SdkPojo, Serializable, ToCopyableBuilder<TdscdmaNmrObj.Builder, TdscdmaNmrObj> {
    private static final SdkField<Integer> UARFCN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Uarfcn").getter(getter(TdscdmaNmrObj::uarfcn)).setter(setter(Builder::uarfcn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uarfcn").build()).build();

    private static final SdkField<Integer> CELL_PARAMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CellParams").getter(getter(TdscdmaNmrObj::cellParams)).setter(setter(Builder::cellParams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellParams").build()).build();

    private static final SdkField<Integer> UTRAN_CID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UtranCid").getter(getter(TdscdmaNmrObj::utranCid)).setter(setter(Builder::utranCid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtranCid").build()).build();

    private static final SdkField<Integer> RSCP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Rscp")
            .getter(getter(TdscdmaNmrObj::rscp)).setter(setter(Builder::rscp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rscp").build()).build();

    private static final SdkField<Integer> PATH_LOSS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PathLoss").getter(getter(TdscdmaNmrObj::pathLoss)).setter(setter(Builder::pathLoss))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathLoss").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UARFCN_FIELD,
            CELL_PARAMS_FIELD, UTRAN_CID_FIELD, RSCP_FIELD, PATH_LOSS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer uarfcn;

    private final Integer cellParams;

    private final Integer utranCid;

    private final Integer rscp;

    private final Integer pathLoss;

    private TdscdmaNmrObj(BuilderImpl builder) {
        this.uarfcn = builder.uarfcn;
        this.cellParams = builder.cellParams;
        this.utranCid = builder.utranCid;
        this.rscp = builder.rscp;
        this.pathLoss = builder.pathLoss;
    }

    /**
     * <p>
     * TD-SCDMA UTRA (Universal Terrestrial Radio Access Network) absolute RF channel number.
     * </p>
     * 
     * @return TD-SCDMA UTRA (Universal Terrestrial Radio Access Network) absolute RF channel number.
     */
    public final Integer uarfcn() {
        return uarfcn;
    }

    /**
     * <p>
     * Cell parameters for TD-SCDMA network measurement reports object.
     * </p>
     * 
     * @return Cell parameters for TD-SCDMA network measurement reports object.
     */
    public final Integer cellParams() {
        return cellParams;
    }

    /**
     * <p>
     * UTRAN (UMTS Terrestrial Radio Access Network) cell global identifier.
     * </p>
     * 
     * @return UTRAN (UMTS Terrestrial Radio Access Network) cell global identifier.
     */
    public final Integer utranCid() {
        return utranCid;
    }

    /**
     * <p>
     * Code power of the received signal, measured in decibel-milliwatts (dBm).
     * </p>
     * 
     * @return Code power of the received signal, measured in decibel-milliwatts (dBm).
     */
    public final Integer rscp() {
        return rscp;
    }

    /**
     * <p>
     * Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it propagates
     * through space.
     * </p>
     * 
     * @return Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it
     *         propagates through space.
     */
    public final Integer pathLoss() {
        return pathLoss;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uarfcn());
        hashCode = 31 * hashCode + Objects.hashCode(cellParams());
        hashCode = 31 * hashCode + Objects.hashCode(utranCid());
        hashCode = 31 * hashCode + Objects.hashCode(rscp());
        hashCode = 31 * hashCode + Objects.hashCode(pathLoss());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TdscdmaNmrObj)) {
            return false;
        }
        TdscdmaNmrObj other = (TdscdmaNmrObj) obj;
        return Objects.equals(uarfcn(), other.uarfcn()) && Objects.equals(cellParams(), other.cellParams())
                && Objects.equals(utranCid(), other.utranCid()) && Objects.equals(rscp(), other.rscp())
                && Objects.equals(pathLoss(), other.pathLoss());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TdscdmaNmrObj").add("Uarfcn", uarfcn()).add("CellParams", cellParams())
                .add("UtranCid", utranCid()).add("Rscp", rscp()).add("PathLoss", pathLoss()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Uarfcn":
            return Optional.ofNullable(clazz.cast(uarfcn()));
        case "CellParams":
            return Optional.ofNullable(clazz.cast(cellParams()));
        case "UtranCid":
            return Optional.ofNullable(clazz.cast(utranCid()));
        case "Rscp":
            return Optional.ofNullable(clazz.cast(rscp()));
        case "PathLoss":
            return Optional.ofNullable(clazz.cast(pathLoss()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TdscdmaNmrObj, T> g) {
        return obj -> g.apply((TdscdmaNmrObj) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TdscdmaNmrObj> {
        /**
         * <p>
         * TD-SCDMA UTRA (Universal Terrestrial Radio Access Network) absolute RF channel number.
         * </p>
         * 
         * @param uarfcn
         *        TD-SCDMA UTRA (Universal Terrestrial Radio Access Network) absolute RF channel number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uarfcn(Integer uarfcn);

        /**
         * <p>
         * Cell parameters for TD-SCDMA network measurement reports object.
         * </p>
         * 
         * @param cellParams
         *        Cell parameters for TD-SCDMA network measurement reports object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellParams(Integer cellParams);

        /**
         * <p>
         * UTRAN (UMTS Terrestrial Radio Access Network) cell global identifier.
         * </p>
         * 
         * @param utranCid
         *        UTRAN (UMTS Terrestrial Radio Access Network) cell global identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utranCid(Integer utranCid);

        /**
         * <p>
         * Code power of the received signal, measured in decibel-milliwatts (dBm).
         * </p>
         * 
         * @param rscp
         *        Code power of the received signal, measured in decibel-milliwatts (dBm).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rscp(Integer rscp);

        /**
         * <p>
         * Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it propagates
         * through space.
         * </p>
         * 
         * @param pathLoss
         *        Path loss, or path attenuation, is the reduction in power density of an electromagnetic wave as it
         *        propagates through space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathLoss(Integer pathLoss);
    }

    static final class BuilderImpl implements Builder {
        private Integer uarfcn;

        private Integer cellParams;

        private Integer utranCid;

        private Integer rscp;

        private Integer pathLoss;

        private BuilderImpl() {
        }

        private BuilderImpl(TdscdmaNmrObj model) {
            uarfcn(model.uarfcn);
            cellParams(model.cellParams);
            utranCid(model.utranCid);
            rscp(model.rscp);
            pathLoss(model.pathLoss);
        }

        public final Integer getUarfcn() {
            return uarfcn;
        }

        public final void setUarfcn(Integer uarfcn) {
            this.uarfcn = uarfcn;
        }

        @Override
        public final Builder uarfcn(Integer uarfcn) {
            this.uarfcn = uarfcn;
            return this;
        }

        public final Integer getCellParams() {
            return cellParams;
        }

        public final void setCellParams(Integer cellParams) {
            this.cellParams = cellParams;
        }

        @Override
        public final Builder cellParams(Integer cellParams) {
            this.cellParams = cellParams;
            return this;
        }

        public final Integer getUtranCid() {
            return utranCid;
        }

        public final void setUtranCid(Integer utranCid) {
            this.utranCid = utranCid;
        }

        @Override
        public final Builder utranCid(Integer utranCid) {
            this.utranCid = utranCid;
            return this;
        }

        public final Integer getRscp() {
            return rscp;
        }

        public final void setRscp(Integer rscp) {
            this.rscp = rscp;
        }

        @Override
        public final Builder rscp(Integer rscp) {
            this.rscp = rscp;
            return this;
        }

        public final Integer getPathLoss() {
            return pathLoss;
        }

        public final void setPathLoss(Integer pathLoss) {
            this.pathLoss = pathLoss;
        }

        @Override
        public final Builder pathLoss(Integer pathLoss) {
            this.pathLoss = pathLoss;
            return this;
        }

        @Override
        public TdscdmaNmrObj build() {
            return new TdscdmaNmrObj(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
