/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * GSM object for network measurement reports.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GsmNmrObj implements SdkPojo, Serializable, ToCopyableBuilder<GsmNmrObj.Builder, GsmNmrObj> {
    private static final SdkField<Integer> BSIC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Bsic")
            .getter(getter(GsmNmrObj::bsic)).setter(setter(Builder::bsic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bsic").build()).build();

    private static final SdkField<Integer> BCCH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Bcch")
            .getter(getter(GsmNmrObj::bcch)).setter(setter(Builder::bcch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bcch").build()).build();

    private static final SdkField<Integer> RX_LEVEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RxLevel").getter(getter(GsmNmrObj::rxLevel)).setter(setter(Builder::rxLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RxLevel").build()).build();

    private static final SdkField<GlobalIdentity> GLOBAL_IDENTITY_FIELD = SdkField
            .<GlobalIdentity> builder(MarshallingType.SDK_POJO).memberName("GlobalIdentity")
            .getter(getter(GsmNmrObj::globalIdentity)).setter(setter(Builder::globalIdentity))
            .constructor(GlobalIdentity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalIdentity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BSIC_FIELD, BCCH_FIELD,
            RX_LEVEL_FIELD, GLOBAL_IDENTITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer bsic;

    private final Integer bcch;

    private final Integer rxLevel;

    private final GlobalIdentity globalIdentity;

    private GsmNmrObj(BuilderImpl builder) {
        this.bsic = builder.bsic;
        this.bcch = builder.bcch;
        this.rxLevel = builder.rxLevel;
        this.globalIdentity = builder.globalIdentity;
    }

    /**
     * <p>
     * GSM base station identity code (BSIC).
     * </p>
     * 
     * @return GSM base station identity code (BSIC).
     */
    public final Integer bsic() {
        return bsic;
    }

    /**
     * <p>
     * GSM broadcast control channel.
     * </p>
     * 
     * @return GSM broadcast control channel.
     */
    public final Integer bcch() {
        return bcch;
    }

    /**
     * <p>
     * Rx level, which is the received signal power, measured in dBm (decibel-milliwatts).
     * </p>
     * 
     * @return Rx level, which is the received signal power, measured in dBm (decibel-milliwatts).
     */
    public final Integer rxLevel() {
        return rxLevel;
    }

    /**
     * <p>
     * Global identity information of the GSM object.
     * </p>
     * 
     * @return Global identity information of the GSM object.
     */
    public final GlobalIdentity globalIdentity() {
        return globalIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bsic());
        hashCode = 31 * hashCode + Objects.hashCode(bcch());
        hashCode = 31 * hashCode + Objects.hashCode(rxLevel());
        hashCode = 31 * hashCode + Objects.hashCode(globalIdentity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GsmNmrObj)) {
            return false;
        }
        GsmNmrObj other = (GsmNmrObj) obj;
        return Objects.equals(bsic(), other.bsic()) && Objects.equals(bcch(), other.bcch())
                && Objects.equals(rxLevel(), other.rxLevel()) && Objects.equals(globalIdentity(), other.globalIdentity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GsmNmrObj").add("Bsic", bsic()).add("Bcch", bcch()).add("RxLevel", rxLevel())
                .add("GlobalIdentity", globalIdentity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bsic":
            return Optional.ofNullable(clazz.cast(bsic()));
        case "Bcch":
            return Optional.ofNullable(clazz.cast(bcch()));
        case "RxLevel":
            return Optional.ofNullable(clazz.cast(rxLevel()));
        case "GlobalIdentity":
            return Optional.ofNullable(clazz.cast(globalIdentity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GsmNmrObj, T> g) {
        return obj -> g.apply((GsmNmrObj) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GsmNmrObj> {
        /**
         * <p>
         * GSM base station identity code (BSIC).
         * </p>
         * 
         * @param bsic
         *        GSM base station identity code (BSIC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bsic(Integer bsic);

        /**
         * <p>
         * GSM broadcast control channel.
         * </p>
         * 
         * @param bcch
         *        GSM broadcast control channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bcch(Integer bcch);

        /**
         * <p>
         * Rx level, which is the received signal power, measured in dBm (decibel-milliwatts).
         * </p>
         * 
         * @param rxLevel
         *        Rx level, which is the received signal power, measured in dBm (decibel-milliwatts).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rxLevel(Integer rxLevel);

        /**
         * <p>
         * Global identity information of the GSM object.
         * </p>
         * 
         * @param globalIdentity
         *        Global identity information of the GSM object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalIdentity(GlobalIdentity globalIdentity);

        /**
         * <p>
         * Global identity information of the GSM object.
         * </p>
         * This is a convenience method that creates an instance of the {@link GlobalIdentity.Builder} avoiding the need
         * to create one manually via {@link GlobalIdentity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GlobalIdentity.Builder#build()} is called immediately and its
         * result is passed to {@link #globalIdentity(GlobalIdentity)}.
         * 
         * @param globalIdentity
         *        a consumer that will call methods on {@link GlobalIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalIdentity(GlobalIdentity)
         */
        default Builder globalIdentity(Consumer<GlobalIdentity.Builder> globalIdentity) {
            return globalIdentity(GlobalIdentity.builder().applyMutation(globalIdentity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer bsic;

        private Integer bcch;

        private Integer rxLevel;

        private GlobalIdentity globalIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(GsmNmrObj model) {
            bsic(model.bsic);
            bcch(model.bcch);
            rxLevel(model.rxLevel);
            globalIdentity(model.globalIdentity);
        }

        public final Integer getBsic() {
            return bsic;
        }

        public final void setBsic(Integer bsic) {
            this.bsic = bsic;
        }

        @Override
        public final Builder bsic(Integer bsic) {
            this.bsic = bsic;
            return this;
        }

        public final Integer getBcch() {
            return bcch;
        }

        public final void setBcch(Integer bcch) {
            this.bcch = bcch;
        }

        @Override
        public final Builder bcch(Integer bcch) {
            this.bcch = bcch;
            return this;
        }

        public final Integer getRxLevel() {
            return rxLevel;
        }

        public final void setRxLevel(Integer rxLevel) {
            this.rxLevel = rxLevel;
        }

        @Override
        public final Builder rxLevel(Integer rxLevel) {
            this.rxLevel = rxLevel;
            return this;
        }

        public final GlobalIdentity.Builder getGlobalIdentity() {
            return globalIdentity != null ? globalIdentity.toBuilder() : null;
        }

        public final void setGlobalIdentity(GlobalIdentity.BuilderImpl globalIdentity) {
            this.globalIdentity = globalIdentity != null ? globalIdentity.build() : null;
        }

        @Override
        public final Builder globalIdentity(GlobalIdentity globalIdentity) {
            this.globalIdentity = globalIdentity;
            return this;
        }

        @Override
        public GsmNmrObj build() {
            return new GsmNmrObj(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
