/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFuotaTaskResponse extends IotWirelessResponse implements
        ToCopyableBuilder<GetFuotaTaskResponse.Builder, GetFuotaTaskResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetFuotaTaskResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetFuotaTaskResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetFuotaTaskResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetFuotaTaskResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetFuotaTaskResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<LoRaWANFuotaTaskGetInfo> LO_RA_WAN_FIELD = SdkField
            .<LoRaWANFuotaTaskGetInfo> builder(MarshallingType.SDK_POJO).memberName("LoRaWAN")
            .getter(getter(GetFuotaTaskResponse::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANFuotaTaskGetInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final SdkField<String> FIRMWARE_UPDATE_IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirmwareUpdateImage").getter(getter(GetFuotaTaskResponse::firmwareUpdateImage))
            .setter(setter(Builder::firmwareUpdateImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirmwareUpdateImage").build())
            .build();

    private static final SdkField<String> FIRMWARE_UPDATE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirmwareUpdateRole").getter(getter(GetFuotaTaskResponse::firmwareUpdateRole))
            .setter(setter(Builder::firmwareUpdateRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirmwareUpdateRole").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(GetFuotaTaskResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Integer> REDUNDANCY_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RedundancyPercent").getter(getter(GetFuotaTaskResponse::redundancyPercent))
            .setter(setter(Builder::redundancyPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedundancyPercent").build()).build();

    private static final SdkField<Integer> FRAGMENT_SIZE_BYTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FragmentSizeBytes").getter(getter(GetFuotaTaskResponse::fragmentSizeBytes))
            .setter(setter(Builder::fragmentSizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentSizeBytes").build()).build();

    private static final SdkField<Integer> FRAGMENT_INTERVAL_MS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FragmentIntervalMS").getter(getter(GetFuotaTaskResponse::fragmentIntervalMS))
            .setter(setter(Builder::fragmentIntervalMS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentIntervalMS").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            STATUS_FIELD, NAME_FIELD, DESCRIPTION_FIELD, LO_RA_WAN_FIELD, FIRMWARE_UPDATE_IMAGE_FIELD,
            FIRMWARE_UPDATE_ROLE_FIELD, CREATED_AT_FIELD, REDUNDANCY_PERCENT_FIELD, FRAGMENT_SIZE_BYTES_FIELD,
            FRAGMENT_INTERVAL_MS_FIELD));

    private final String arn;

    private final String id;

    private final String status;

    private final String name;

    private final String description;

    private final LoRaWANFuotaTaskGetInfo loRaWAN;

    private final String firmwareUpdateImage;

    private final String firmwareUpdateRole;

    private final Instant createdAt;

    private final Integer redundancyPercent;

    private final Integer fragmentSizeBytes;

    private final Integer fragmentIntervalMS;

    private GetFuotaTaskResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.status = builder.status;
        this.name = builder.name;
        this.description = builder.description;
        this.loRaWAN = builder.loRaWAN;
        this.firmwareUpdateImage = builder.firmwareUpdateImage;
        this.firmwareUpdateRole = builder.firmwareUpdateRole;
        this.createdAt = builder.createdAt;
        this.redundancyPercent = builder.redundancyPercent;
        this.fragmentSizeBytes = builder.fragmentSizeBytes;
        this.fragmentIntervalMS = builder.fragmentIntervalMS;
    }

    /**
     * Returns the value of the Arn property for this object.
     * 
     * @return The value of the Arn property for this object.
     */
    public final String arn() {
        return arn;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FuotaTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see FuotaTaskStatus
     */
    public final FuotaTaskStatus status() {
        return FuotaTaskStatus.fromValue(status);
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FuotaTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see FuotaTaskStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the LoRaWAN property for this object.
     * 
     * @return The value of the LoRaWAN property for this object.
     */
    public final LoRaWANFuotaTaskGetInfo loRaWAN() {
        return loRaWAN;
    }

    /**
     * Returns the value of the FirmwareUpdateImage property for this object.
     * 
     * @return The value of the FirmwareUpdateImage property for this object.
     */
    public final String firmwareUpdateImage() {
        return firmwareUpdateImage;
    }

    /**
     * Returns the value of the FirmwareUpdateRole property for this object.
     * 
     * @return The value of the FirmwareUpdateRole property for this object.
     */
    public final String firmwareUpdateRole() {
        return firmwareUpdateRole;
    }

    /**
     * Returns the value of the CreatedAt property for this object.
     * 
     * @return The value of the CreatedAt property for this object.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * Returns the value of the RedundancyPercent property for this object.
     * 
     * @return The value of the RedundancyPercent property for this object.
     */
    public final Integer redundancyPercent() {
        return redundancyPercent;
    }

    /**
     * Returns the value of the FragmentSizeBytes property for this object.
     * 
     * @return The value of the FragmentSizeBytes property for this object.
     */
    public final Integer fragmentSizeBytes() {
        return fragmentSizeBytes;
    }

    /**
     * Returns the value of the FragmentIntervalMS property for this object.
     * 
     * @return The value of the FragmentIntervalMS property for this object.
     */
    public final Integer fragmentIntervalMS() {
        return fragmentIntervalMS;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(firmwareUpdateImage());
        hashCode = 31 * hashCode + Objects.hashCode(firmwareUpdateRole());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(redundancyPercent());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentIntervalMS());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFuotaTaskResponse)) {
            return false;
        }
        GetFuotaTaskResponse other = (GetFuotaTaskResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(loRaWAN(), other.loRaWAN())
                && Objects.equals(firmwareUpdateImage(), other.firmwareUpdateImage())
                && Objects.equals(firmwareUpdateRole(), other.firmwareUpdateRole())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(redundancyPercent(), other.redundancyPercent())
                && Objects.equals(fragmentSizeBytes(), other.fragmentSizeBytes())
                && Objects.equals(fragmentIntervalMS(), other.fragmentIntervalMS());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFuotaTaskResponse").add("Arn", arn()).add("Id", id()).add("Status", statusAsString())
                .add("Name", name()).add("Description", description()).add("LoRaWAN", loRaWAN())
                .add("FirmwareUpdateImage", firmwareUpdateImage()).add("FirmwareUpdateRole", firmwareUpdateRole())
                .add("CreatedAt", createdAt()).add("RedundancyPercent", redundancyPercent())
                .add("FragmentSizeBytes", fragmentSizeBytes()).add("FragmentIntervalMS", fragmentIntervalMS()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        case "FirmwareUpdateImage":
            return Optional.ofNullable(clazz.cast(firmwareUpdateImage()));
        case "FirmwareUpdateRole":
            return Optional.ofNullable(clazz.cast(firmwareUpdateRole()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "RedundancyPercent":
            return Optional.ofNullable(clazz.cast(redundancyPercent()));
        case "FragmentSizeBytes":
            return Optional.ofNullable(clazz.cast(fragmentSizeBytes()));
        case "FragmentIntervalMS":
            return Optional.ofNullable(clazz.cast(fragmentIntervalMS()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFuotaTaskResponse, T> g) {
        return obj -> g.apply((GetFuotaTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFuotaTaskResponse> {
        /**
         * Sets the value of the Arn property for this object.
         *
         * @param arn
         *        The new value for the Arn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Sets the value of the Id property for this object.
         *
         * @param id
         *        The new value for the Id property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see FuotaTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FuotaTaskStatus
         */
        Builder status(String status);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see FuotaTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FuotaTaskStatus
         */
        Builder status(FuotaTaskStatus status);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the LoRaWAN property for this object.
         *
         * @param loRaWAN
         *        The new value for the LoRaWAN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANFuotaTaskGetInfo loRaWAN);

        /**
         * Sets the value of the LoRaWAN property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LoRaWANFuotaTaskGetInfo.Builder} avoiding
         * the need to create one manually via {@link LoRaWANFuotaTaskGetInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoRaWANFuotaTaskGetInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #loRaWAN(LoRaWANFuotaTaskGetInfo)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on {@link LoRaWANFuotaTaskGetInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANFuotaTaskGetInfo)
         */
        default Builder loRaWAN(Consumer<LoRaWANFuotaTaskGetInfo.Builder> loRaWAN) {
            return loRaWAN(LoRaWANFuotaTaskGetInfo.builder().applyMutation(loRaWAN).build());
        }

        /**
         * Sets the value of the FirmwareUpdateImage property for this object.
         *
         * @param firmwareUpdateImage
         *        The new value for the FirmwareUpdateImage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firmwareUpdateImage(String firmwareUpdateImage);

        /**
         * Sets the value of the FirmwareUpdateRole property for this object.
         *
         * @param firmwareUpdateRole
         *        The new value for the FirmwareUpdateRole property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firmwareUpdateRole(String firmwareUpdateRole);

        /**
         * Sets the value of the CreatedAt property for this object.
         *
         * @param createdAt
         *        The new value for the CreatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * Sets the value of the RedundancyPercent property for this object.
         *
         * @param redundancyPercent
         *        The new value for the RedundancyPercent property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redundancyPercent(Integer redundancyPercent);

        /**
         * Sets the value of the FragmentSizeBytes property for this object.
         *
         * @param fragmentSizeBytes
         *        The new value for the FragmentSizeBytes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentSizeBytes(Integer fragmentSizeBytes);

        /**
         * Sets the value of the FragmentIntervalMS property for this object.
         *
         * @param fragmentIntervalMS
         *        The new value for the FragmentIntervalMS property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentIntervalMS(Integer fragmentIntervalMS);
    }

    static final class BuilderImpl extends IotWirelessResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String status;

        private String name;

        private String description;

        private LoRaWANFuotaTaskGetInfo loRaWAN;

        private String firmwareUpdateImage;

        private String firmwareUpdateRole;

        private Instant createdAt;

        private Integer redundancyPercent;

        private Integer fragmentSizeBytes;

        private Integer fragmentIntervalMS;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFuotaTaskResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            status(model.status);
            name(model.name);
            description(model.description);
            loRaWAN(model.loRaWAN);
            firmwareUpdateImage(model.firmwareUpdateImage);
            firmwareUpdateRole(model.firmwareUpdateRole);
            createdAt(model.createdAt);
            redundancyPercent(model.redundancyPercent);
            fragmentSizeBytes(model.fragmentSizeBytes);
            fragmentIntervalMS(model.fragmentIntervalMS);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FuotaTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final LoRaWANFuotaTaskGetInfo.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANFuotaTaskGetInfo.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANFuotaTaskGetInfo loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final String getFirmwareUpdateImage() {
            return firmwareUpdateImage;
        }

        public final void setFirmwareUpdateImage(String firmwareUpdateImage) {
            this.firmwareUpdateImage = firmwareUpdateImage;
        }

        @Override
        public final Builder firmwareUpdateImage(String firmwareUpdateImage) {
            this.firmwareUpdateImage = firmwareUpdateImage;
            return this;
        }

        public final String getFirmwareUpdateRole() {
            return firmwareUpdateRole;
        }

        public final void setFirmwareUpdateRole(String firmwareUpdateRole) {
            this.firmwareUpdateRole = firmwareUpdateRole;
        }

        @Override
        public final Builder firmwareUpdateRole(String firmwareUpdateRole) {
            this.firmwareUpdateRole = firmwareUpdateRole;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Integer getRedundancyPercent() {
            return redundancyPercent;
        }

        public final void setRedundancyPercent(Integer redundancyPercent) {
            this.redundancyPercent = redundancyPercent;
        }

        @Override
        public final Builder redundancyPercent(Integer redundancyPercent) {
            this.redundancyPercent = redundancyPercent;
            return this;
        }

        public final Integer getFragmentSizeBytes() {
            return fragmentSizeBytes;
        }

        public final void setFragmentSizeBytes(Integer fragmentSizeBytes) {
            this.fragmentSizeBytes = fragmentSizeBytes;
        }

        @Override
        public final Builder fragmentSizeBytes(Integer fragmentSizeBytes) {
            this.fragmentSizeBytes = fragmentSizeBytes;
            return this;
        }

        public final Integer getFragmentIntervalMS() {
            return fragmentIntervalMS;
        }

        public final void setFragmentIntervalMS(Integer fragmentIntervalMS) {
            this.fragmentIntervalMS = fragmentIntervalMS;
        }

        @Override
        public final Builder fragmentIntervalMS(Integer fragmentIntervalMS) {
            this.fragmentIntervalMS = fragmentIntervalMS;
            return this;
        }

        @Override
        public GetFuotaTaskResponse build() {
            return new GetFuotaTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
