/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessAsyncClient;
import software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListNetworkAnalyzerConfigurationsResponse;

public class ListNetworkAnalyzerConfigurationsPublisher
implements SdkPublisher<ListNetworkAnalyzerConfigurationsResponse> {
    private final IotWirelessAsyncClient client;
    private final ListNetworkAnalyzerConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNetworkAnalyzerConfigurationsPublisher(IotWirelessAsyncClient client, ListNetworkAnalyzerConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNetworkAnalyzerConfigurationsPublisher(IotWirelessAsyncClient client, ListNetworkAnalyzerConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNetworkAnalyzerConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNetworkAnalyzerConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListNetworkAnalyzerConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListNetworkAnalyzerConfigurationsResponse> {
        private ListNetworkAnalyzerConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListNetworkAnalyzerConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNetworkAnalyzerConfigurationsResponse> nextPage(ListNetworkAnalyzerConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListNetworkAnalyzerConfigurationsPublisher.this.client.listNetworkAnalyzerConfigurations(ListNetworkAnalyzerConfigurationsPublisher.this.firstRequest);
            }
            return ListNetworkAnalyzerConfigurationsPublisher.this.client.listNetworkAnalyzerConfigurations((ListNetworkAnalyzerConfigurationsRequest)((Object)ListNetworkAnalyzerConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

