/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.JoinEuiFiltersCopier;
import software.amazon.awssdk.services.iotwireless.model.NetIdFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWirelessGatewayRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, UpdateWirelessGatewayRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateWirelessGatewayRequest.getter(UpdateWirelessGatewayRequest::id)).setter(UpdateWirelessGatewayRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateWirelessGatewayRequest.getter(UpdateWirelessGatewayRequest::name)).setter(UpdateWirelessGatewayRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateWirelessGatewayRequest.getter(UpdateWirelessGatewayRequest::description)).setter(UpdateWirelessGatewayRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<List<String>>> JOIN_EUI_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JoinEuiFilters").getter(UpdateWirelessGatewayRequest.getter(UpdateWirelessGatewayRequest::joinEuiFilters)).setter(UpdateWirelessGatewayRequest.setter(Builder::joinEuiFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinEuiFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<String>> NET_ID_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetIdFilters").getter(UpdateWirelessGatewayRequest.getter(UpdateWirelessGatewayRequest::netIdFilters)).setter(UpdateWirelessGatewayRequest.setter(Builder::netIdFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetIdFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, JOIN_EUI_FILTERS_FIELD, NET_ID_FILTERS_FIELD));
    private final String id;
    private final String name;
    private final String description;
    private final List<List<String>> joinEuiFilters;
    private final List<String> netIdFilters;

    private UpdateWirelessGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.joinEuiFilters = builder.joinEuiFilters;
        this.netIdFilters = builder.netIdFilters;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasJoinEuiFilters() {
        return this.joinEuiFilters != null && !(this.joinEuiFilters instanceof SdkAutoConstructList);
    }

    public final List<List<String>> joinEuiFilters() {
        return this.joinEuiFilters;
    }

    public final boolean hasNetIdFilters() {
        return this.netIdFilters != null && !(this.netIdFilters instanceof SdkAutoConstructList);
    }

    public final List<String> netIdFilters() {
        return this.netIdFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJoinEuiFilters() ? this.joinEuiFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetIdFilters() ? this.netIdFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWirelessGatewayRequest)) {
            return false;
        }
        UpdateWirelessGatewayRequest other = (UpdateWirelessGatewayRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasJoinEuiFilters() == other.hasJoinEuiFilters() && Objects.equals(this.joinEuiFilters(), other.joinEuiFilters()) && this.hasNetIdFilters() == other.hasNetIdFilters() && Objects.equals(this.netIdFilters(), other.netIdFilters());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWirelessGatewayRequest").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("JoinEuiFilters", this.hasJoinEuiFilters() ? this.joinEuiFilters() : null).add("NetIdFilters", this.hasNetIdFilters() ? this.netIdFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "JoinEuiFilters": {
                return Optional.ofNullable(clazz.cast(this.joinEuiFilters()));
            }
            case "NetIdFilters": {
                return Optional.ofNullable(clazz.cast(this.netIdFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWirelessGatewayRequest, T> g) {
        return obj -> g.apply((UpdateWirelessGatewayRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private List<List<String>> joinEuiFilters = DefaultSdkAutoConstructList.getInstance();
        private List<String> netIdFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWirelessGatewayRequest model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.joinEuiFilters(model.joinEuiFilters);
            this.netIdFilters(model.netIdFilters);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<? extends Collection<String>> getJoinEuiFilters() {
            if (this.joinEuiFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.joinEuiFilters;
        }

        public final void setJoinEuiFilters(Collection<? extends Collection<String>> joinEuiFilters) {
            this.joinEuiFilters = JoinEuiFiltersCopier.copy(joinEuiFilters);
        }

        @Override
        @Transient
        public final Builder joinEuiFilters(Collection<? extends Collection<String>> joinEuiFilters) {
            this.joinEuiFilters = JoinEuiFiltersCopier.copy(joinEuiFilters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder joinEuiFilters(Collection<String> ... joinEuiFilters) {
            this.joinEuiFilters((Collection<? extends Collection<String>>)Arrays.asList(joinEuiFilters));
            return this;
        }

        public final Collection<String> getNetIdFilters() {
            if (this.netIdFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.netIdFilters;
        }

        public final void setNetIdFilters(Collection<String> netIdFilters) {
            this.netIdFilters = NetIdFiltersCopier.copy(netIdFilters);
        }

        @Override
        @Transient
        public final Builder netIdFilters(Collection<String> netIdFilters) {
            this.netIdFilters = NetIdFiltersCopier.copy(netIdFilters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder netIdFilters(String ... netIdFilters) {
            this.netIdFilters(Arrays.asList(netIdFilters));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWirelessGatewayRequest build() {
            return new UpdateWirelessGatewayRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWirelessGatewayRequest> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder joinEuiFilters(Collection<? extends Collection<String>> var1);

        public Builder joinEuiFilters(Collection<String> ... var1);

        public Builder netIdFilters(Collection<String> var1);

        public Builder netIdFilters(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

