/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.MessageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SidewalkSendDataToDevice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SidewalkSendDataToDevice> {
    private static final SdkField<Integer> SEQ_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Seq").getter(SidewalkSendDataToDevice.getter(SidewalkSendDataToDevice::seq)).setter(SidewalkSendDataToDevice.setter(Builder::seq)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Seq").build()}).build();
    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageType").getter(SidewalkSendDataToDevice.getter(SidewalkSendDataToDevice::messageTypeAsString)).setter(SidewalkSendDataToDevice.setter(Builder::messageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQ_FIELD, MESSAGE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer seq;
    private final String messageType;

    private SidewalkSendDataToDevice(BuilderImpl builder) {
        this.seq = builder.seq;
        this.messageType = builder.messageType;
    }

    public final Integer seq() {
        return this.seq;
    }

    public final MessageType messageType() {
        return MessageType.fromValue(this.messageType);
    }

    public final String messageTypeAsString() {
        return this.messageType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.seq());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkSendDataToDevice)) {
            return false;
        }
        SidewalkSendDataToDevice other = (SidewalkSendDataToDevice)obj;
        return Objects.equals(this.seq(), other.seq()) && Objects.equals(this.messageTypeAsString(), other.messageTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SidewalkSendDataToDevice").add("Seq", (Object)this.seq()).add("MessageType", (Object)this.messageTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Seq": {
                return Optional.ofNullable(clazz.cast(this.seq()));
            }
            case "MessageType": {
                return Optional.ofNullable(clazz.cast(this.messageTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SidewalkSendDataToDevice, T> g) {
        return obj -> g.apply((SidewalkSendDataToDevice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer seq;
        private String messageType;

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkSendDataToDevice model) {
            this.seq(model.seq);
            this.messageType(model.messageType);
        }

        public final Integer getSeq() {
            return this.seq;
        }

        public final void setSeq(Integer seq) {
            this.seq = seq;
        }

        @Override
        @Transient
        public final Builder seq(Integer seq) {
            this.seq = seq;
            return this;
        }

        public final String getMessageType() {
            return this.messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        @Transient
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        @Transient
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public SidewalkSendDataToDevice build() {
            return new SidewalkSendDataToDevice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SidewalkSendDataToDevice> {
        public Builder seq(Integer var1);

        public Builder messageType(String var1);

        public Builder messageType(MessageType var1);
    }
}

