/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WirelessGatewayEvent {
    CUPS_REQUEST("CUPS_Request"),
    CERTIFICATE("Certificate"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WirelessGatewayEvent> VALUE_MAP;
    private final String value;

    private WirelessGatewayEvent(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WirelessGatewayEvent fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WirelessGatewayEvent> knownValues() {
        EnumSet<WirelessGatewayEvent> knownValues = EnumSet.allOf(WirelessGatewayEvent.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WirelessGatewayEvent.class, WirelessGatewayEvent::toString);
    }
}

